package gov.hhs.cms.bluebutton.datapipeline.ccw.jdo;

import javax.jdo.query.*;
import org.datanucleus.api.jdo.query.*;

public class QPartAClaimFact extends PersistableExpressionImpl<PartAClaimFact> implements PersistableExpression<PartAClaimFact>
{
    public static final QPartAClaimFact jdoCandidate = candidate("this");

    public static QPartAClaimFact candidate(String name)
    {
        return new QPartAClaimFact(null, name, 5);
    }

    public static QPartAClaimFact candidate()
    {
        return jdoCandidate;
    }

    public static QPartAClaimFact parameter(String name)
    {
        return new QPartAClaimFact(PartAClaimFact.class, name, ExpressionType.PARAMETER);
    }

    public static QPartAClaimFact variable(String name)
    {
        return new QPartAClaimFact(PartAClaimFact.class, name, ExpressionType.VARIABLE);
    }

    public final ObjectExpression<java.lang.Long> id;
    public final gov.hhs.cms.bluebutton.datapipeline.ccw.jdo.QCurrentBeneficiary beneficiary;
    public final gov.hhs.cms.bluebutton.datapipeline.ccw.jdo.QAllClaimsProfile claimProfile;
    public final gov.hhs.cms.bluebutton.datapipeline.ccw.jdo.QDiagnosisRelatedGroup diagnosisGroup;
    public final LocalDateExpression dateAdmission;
    public final LocalDateExpression dateFrom;
    public final LocalDateExpression dateThrough;
    public final LocalDateExpression dateDischarge;
    public final ObjectExpression<java.lang.Long> providerAtTimeOfClaimNpi;
    public final ObjectExpression<java.lang.Long> utilizationDayCount;
    public final NumericExpression<java.math.BigDecimal> payment;
    public final NumericExpression<java.math.BigDecimal> passThroughPerDiemAmount;
    public final NumericExpression<java.math.BigDecimal> nchBeneficiaryBloodDeductibleLiability;
    public final NumericExpression<java.math.BigDecimal> nchBeneficiaryInpatientDeductible;
    public final NumericExpression<java.math.BigDecimal> nchBeneficiaryPartACoinsuranceLiability;
    public final NumericExpression<java.math.BigDecimal> nchBeneficiaryPartBDeductible;
    public final NumericExpression<java.math.BigDecimal> nchBeneficiaryPartBCoinsurance;
    public final NumericExpression<java.math.BigDecimal> nchPrimaryPayerPaid;
    public final ObjectExpression<java.lang.Long> attendingPhysicianNpi;
    public final ObjectExpression<java.lang.Long> operatingPhysicianNpi;
    public final ObjectExpression<java.lang.Long> otherPhysicianNpi;
    public final StringExpression admittingDiagnosisCode;
    public final ListExpression claimLines;

    public QPartAClaimFact(PersistableExpression parent, String name, int depth)
    {
        super(parent, name);
        this.id = new ObjectExpressionImpl<java.lang.Long>(this, "id");
        if (depth > 0)
        {
            this.beneficiary = new gov.hhs.cms.bluebutton.datapipeline.ccw.jdo.QCurrentBeneficiary(this, "beneficiary", depth-1);
        }
        else
        {
            this.beneficiary = null;
        }
        if (depth > 0)
        {
            this.claimProfile = new gov.hhs.cms.bluebutton.datapipeline.ccw.jdo.QAllClaimsProfile(this, "claimProfile", depth-1);
        }
        else
        {
            this.claimProfile = null;
        }
        if (depth > 0)
        {
            this.diagnosisGroup = new gov.hhs.cms.bluebutton.datapipeline.ccw.jdo.QDiagnosisRelatedGroup(this, "diagnosisGroup", depth-1);
        }
        else
        {
            this.diagnosisGroup = null;
        }
        this.dateAdmission = new LocalDateExpressionImpl(this, "dateAdmission");
        this.dateFrom = new LocalDateExpressionImpl(this, "dateFrom");
        this.dateThrough = new LocalDateExpressionImpl(this, "dateThrough");
        this.dateDischarge = new LocalDateExpressionImpl(this, "dateDischarge");
        this.providerAtTimeOfClaimNpi = new ObjectExpressionImpl<java.lang.Long>(this, "providerAtTimeOfClaimNpi");
        this.utilizationDayCount = new ObjectExpressionImpl<java.lang.Long>(this, "utilizationDayCount");
        this.payment = new NumericExpressionImpl<java.math.BigDecimal>(this, "payment");
        this.passThroughPerDiemAmount = new NumericExpressionImpl<java.math.BigDecimal>(this, "passThroughPerDiemAmount");
        this.nchBeneficiaryBloodDeductibleLiability = new NumericExpressionImpl<java.math.BigDecimal>(this, "nchBeneficiaryBloodDeductibleLiability");
        this.nchBeneficiaryInpatientDeductible = new NumericExpressionImpl<java.math.BigDecimal>(this, "nchBeneficiaryInpatientDeductible");
        this.nchBeneficiaryPartACoinsuranceLiability = new NumericExpressionImpl<java.math.BigDecimal>(this, "nchBeneficiaryPartACoinsuranceLiability");
        this.nchBeneficiaryPartBDeductible = new NumericExpressionImpl<java.math.BigDecimal>(this, "nchBeneficiaryPartBDeductible");
        this.nchBeneficiaryPartBCoinsurance = new NumericExpressionImpl<java.math.BigDecimal>(this, "nchBeneficiaryPartBCoinsurance");
        this.nchPrimaryPayerPaid = new NumericExpressionImpl<java.math.BigDecimal>(this, "nchPrimaryPayerPaid");
        this.attendingPhysicianNpi = new ObjectExpressionImpl<java.lang.Long>(this, "attendingPhysicianNpi");
        this.operatingPhysicianNpi = new ObjectExpressionImpl<java.lang.Long>(this, "operatingPhysicianNpi");
        this.otherPhysicianNpi = new ObjectExpressionImpl<java.lang.Long>(this, "otherPhysicianNpi");
        this.admittingDiagnosisCode = new StringExpressionImpl(this, "admittingDiagnosisCode");
        this.claimLines = new ListExpressionImpl(this, "claimLines");
    }

    public QPartAClaimFact(Class type, String name, ExpressionType exprType)
    {
        super(type, name, exprType);
        this.id = new ObjectExpressionImpl<java.lang.Long>(this, "id");
        this.beneficiary = new gov.hhs.cms.bluebutton.datapipeline.ccw.jdo.QCurrentBeneficiary(this, "beneficiary", 5);
        this.claimProfile = new gov.hhs.cms.bluebutton.datapipeline.ccw.jdo.QAllClaimsProfile(this, "claimProfile", 5);
        this.diagnosisGroup = new gov.hhs.cms.bluebutton.datapipeline.ccw.jdo.QDiagnosisRelatedGroup(this, "diagnosisGroup", 5);
        this.dateAdmission = new LocalDateExpressionImpl(this, "dateAdmission");
        this.dateFrom = new LocalDateExpressionImpl(this, "dateFrom");
        this.dateThrough = new LocalDateExpressionImpl(this, "dateThrough");
        this.dateDischarge = new LocalDateExpressionImpl(this, "dateDischarge");
        this.providerAtTimeOfClaimNpi = new ObjectExpressionImpl<java.lang.Long>(this, "providerAtTimeOfClaimNpi");
        this.utilizationDayCount = new ObjectExpressionImpl<java.lang.Long>(this, "utilizationDayCount");
        this.payment = new NumericExpressionImpl<java.math.BigDecimal>(this, "payment");
        this.passThroughPerDiemAmount = new NumericExpressionImpl<java.math.BigDecimal>(this, "passThroughPerDiemAmount");
        this.nchBeneficiaryBloodDeductibleLiability = new NumericExpressionImpl<java.math.BigDecimal>(this, "nchBeneficiaryBloodDeductibleLiability");
        this.nchBeneficiaryInpatientDeductible = new NumericExpressionImpl<java.math.BigDecimal>(this, "nchBeneficiaryInpatientDeductible");
        this.nchBeneficiaryPartACoinsuranceLiability = new NumericExpressionImpl<java.math.BigDecimal>(this, "nchBeneficiaryPartACoinsuranceLiability");
        this.nchBeneficiaryPartBDeductible = new NumericExpressionImpl<java.math.BigDecimal>(this, "nchBeneficiaryPartBDeductible");
        this.nchBeneficiaryPartBCoinsurance = new NumericExpressionImpl<java.math.BigDecimal>(this, "nchBeneficiaryPartBCoinsurance");
        this.nchPrimaryPayerPaid = new NumericExpressionImpl<java.math.BigDecimal>(this, "nchPrimaryPayerPaid");
        this.attendingPhysicianNpi = new ObjectExpressionImpl<java.lang.Long>(this, "attendingPhysicianNpi");
        this.operatingPhysicianNpi = new ObjectExpressionImpl<java.lang.Long>(this, "operatingPhysicianNpi");
        this.otherPhysicianNpi = new ObjectExpressionImpl<java.lang.Long>(this, "otherPhysicianNpi");
        this.admittingDiagnosisCode = new StringExpressionImpl(this, "admittingDiagnosisCode");
        this.claimLines = new ListExpressionImpl(this, "claimLines");
    }
}
