package gov.hhs.cms.bluebutton.datapipeline.ccw.jdo;

import javax.jdo.query.*;
import org.datanucleus.api.jdo.query.*;

public class QDiagnosisRelatedGroup extends PersistableExpressionImpl<DiagnosisRelatedGroup> implements PersistableExpression<DiagnosisRelatedGroup>
{
    public static final QDiagnosisRelatedGroup jdoCandidate = candidate("this");

    public static QDiagnosisRelatedGroup candidate(String name)
    {
        return new QDiagnosisRelatedGroup(null, name, 5);
    }

    public static QDiagnosisRelatedGroup candidate()
    {
        return jdoCandidate;
    }

    public static QDiagnosisRelatedGroup parameter(String name)
    {
        return new QDiagnosisRelatedGroup(DiagnosisRelatedGroup.class, name, ExpressionType.PARAMETER);
    }

    public static QDiagnosisRelatedGroup variable(String name)
    {
        return new QDiagnosisRelatedGroup(DiagnosisRelatedGroup.class, name, ExpressionType.VARIABLE);
    }

    public final ObjectExpression<java.lang.Long> id;
    public final StringExpression code;

    public QDiagnosisRelatedGroup(PersistableExpression parent, String name, int depth)
    {
        super(parent, name);
        this.id = new ObjectExpressionImpl<java.lang.Long>(this, "id");
        this.code = new StringExpressionImpl(this, "code");
    }

    public QDiagnosisRelatedGroup(Class type, String name, ExpressionType exprType)
    {
        super(type, name, exprType);
        this.id = new ObjectExpressionImpl<java.lang.Long>(this, "id");
        this.code = new StringExpressionImpl(this, "code");
    }
}
