package gov.hhs.cms.bluebutton.datapipeline.ccw.jdo;

import javax.jdo.query.*;
import org.datanucleus.api.jdo.query.*;

public class QCurrentBeneficiary extends PersistableExpressionImpl<CurrentBeneficiary> implements PersistableExpression<CurrentBeneficiary>
{
    public static final QCurrentBeneficiary jdoCandidate = candidate("this");

    public static QCurrentBeneficiary candidate(String name)
    {
        return new QCurrentBeneficiary(null, name, 5);
    }

    public static QCurrentBeneficiary candidate()
    {
        return jdoCandidate;
    }

    public static QCurrentBeneficiary parameter(String name)
    {
        return new QCurrentBeneficiary(CurrentBeneficiary.class, name, ExpressionType.PARAMETER);
    }

    public static QCurrentBeneficiary variable(String name)
    {
        return new QCurrentBeneficiary(CurrentBeneficiary.class, name, ExpressionType.VARIABLE);
    }

    public final ObjectExpression<java.lang.Integer> id;
    public final LocalDateExpression birthDate;
    public final StringExpression givenName;
    public final StringExpression surname;
    public final StringExpression contactAddress;
    public final StringExpression contactAddressZip;
    public final ListExpression partAClaimFacts;
    public final ListExpression partBClaimFacts;
    public final ListExpression partDEventFacts;

    public QCurrentBeneficiary(PersistableExpression parent, String name, int depth)
    {
        super(parent, name);
        this.id = new ObjectExpressionImpl<java.lang.Integer>(this, "id");
        this.birthDate = new LocalDateExpressionImpl(this, "birthDate");
        this.givenName = new StringExpressionImpl(this, "givenName");
        this.surname = new StringExpressionImpl(this, "surname");
        this.contactAddress = new StringExpressionImpl(this, "contactAddress");
        this.contactAddressZip = new StringExpressionImpl(this, "contactAddressZip");
        this.partAClaimFacts = new ListExpressionImpl(this, "partAClaimFacts");
        this.partBClaimFacts = new ListExpressionImpl(this, "partBClaimFacts");
        this.partDEventFacts = new ListExpressionImpl(this, "partDEventFacts");
    }

    public QCurrentBeneficiary(Class type, String name, ExpressionType exprType)
    {
        super(type, name, exprType);
        this.id = new ObjectExpressionImpl<java.lang.Integer>(this, "id");
        this.birthDate = new LocalDateExpressionImpl(this, "birthDate");
        this.givenName = new StringExpressionImpl(this, "givenName");
        this.surname = new StringExpressionImpl(this, "surname");
        this.contactAddress = new StringExpressionImpl(this, "contactAddress");
        this.contactAddressZip = new StringExpressionImpl(this, "contactAddressZip");
        this.partAClaimFacts = new ListExpressionImpl(this, "partAClaimFacts");
        this.partBClaimFacts = new ListExpressionImpl(this, "partBClaimFacts");
        this.partDEventFacts = new ListExpressionImpl(this, "partDEventFacts");
    }
}
