package gov.hhs.cms.bluebutton.datapipeline.ccw.jdo;

import javax.jdo.query.*;
import org.datanucleus.api.jdo.query.*;

public class QClaimLineMiscCode extends PersistableExpressionImpl<ClaimLineMiscCode> implements PersistableExpression<ClaimLineMiscCode>
{
    public static final QClaimLineMiscCode jdoCandidate = candidate("this");

    public static QClaimLineMiscCode candidate(String name)
    {
        return new QClaimLineMiscCode(null, name, 5);
    }

    public static QClaimLineMiscCode candidate()
    {
        return jdoCandidate;
    }

    public static QClaimLineMiscCode parameter(String name)
    {
        return new QClaimLineMiscCode(ClaimLineMiscCode.class, name, ExpressionType.PARAMETER);
    }

    public static QClaimLineMiscCode variable(String name)
    {
        return new QClaimLineMiscCode(ClaimLineMiscCode.class, name, ExpressionType.VARIABLE);
    }

    public final StringExpression id;
    public final StringExpression code;

    public QClaimLineMiscCode(PersistableExpression parent, String name, int depth)
    {
        super(parent, name);
        this.id = new StringExpressionImpl(this, "id");
        this.code = new StringExpressionImpl(this, "code");
    }

    public QClaimLineMiscCode(Class type, String name, ExpressionType exprType)
    {
        super(type, name, exprType);
        this.id = new StringExpressionImpl(this, "id");
        this.code = new StringExpressionImpl(this, "code");
    }
}
