/*
 * Decompiled with CFR 0.152.
 */
package gov.hhs.cms.bluebutton.datapipeline.ccw.extract;

import gov.hhs.cms.bluebutton.datapipeline.ccw.jdo.CurrentBeneficiary;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.jdo.JDOQLTypedQuery;
import javax.jdo.PersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CcwExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CcwExtractor.class);
    private final PersistenceManager pm;

    @Inject
    public CcwExtractor(PersistenceManager pm) {
        this.pm = pm;
    }

    public Stream<CurrentBeneficiary> extractAllBeneficiaries() {
        JDOQLTypedQuery query = this.pm.newJDOQLTypedQuery(CurrentBeneficiary.class);
        query.extension("datanucleus.query.resultCacheType", (Object)"none");
        query.extension("datanucleus.rdbms.query.resultSetType", (Object)"forward-only");
        query.extension("datanucleus.rdbms.query.fetchDirection", (Object)"forward");
        query.extension("datanucleus.rdbms.query.resultSetConcurrency", (Object)"read-only");
        LOGGER.trace("Querying for beneficiaries...");
        List beneficiariesLazyList = query.executeList();
        LOGGER.trace("Query for beneficiaries completed.");
        Iterator beneficiariesIter = beneficiariesLazyList.iterator();
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(beneficiariesIter, 272), false);
    }
}

