/*
 * Decompiled with CFR 0.152.
 */
package gov.adlnet.xapi.model.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import gov.adlnet.xapi.model.Activity;
import gov.adlnet.xapi.model.Agent;
import gov.adlnet.xapi.model.Group;
import gov.adlnet.xapi.model.IStatementObject;
import gov.adlnet.xapi.model.StatementReference;
import gov.adlnet.xapi.model.SubStatement;
import java.lang.reflect.Type;

public class StatementObjectAdapter
implements JsonSerializer<IStatementObject>,
JsonDeserializer<IStatementObject> {
    private static final String OBJECT_TYPE = "objectType";

    public IStatementObject deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        Class<?> klass = null;
        try {
            if (obj.has(OBJECT_TYPE)) {
                String objectType = obj.get(OBJECT_TYPE).getAsJsonPrimitive().getAsString().toLowerCase();
                if (objectType.equals("Agent".toLowerCase())) {
                    klass = Class.forName(Agent.class.getCanonicalName());
                } else if (objectType.equals("Group".toLowerCase())) {
                    klass = Class.forName(Group.class.getCanonicalName());
                } else if (objectType.equals("Activity".toLowerCase())) {
                    klass = Class.forName(Activity.class.getCanonicalName());
                } else if (objectType.equals("StatementRef".toLowerCase())) {
                    klass = Class.forName(StatementReference.class.getCanonicalName());
                } else if (objectType.equals("SubStatement".toLowerCase())) {
                    klass = Class.forName(SubStatement.class.getCanonicalName());
                }
            } else {
                klass = Class.forName(Activity.class.getCanonicalName());
            }
        }
        catch (ClassNotFoundException e) {
            throw new JsonParseException(e.getMessage());
        }
        return (IStatementObject)context.deserialize(json, klass);
    }

    public JsonElement serialize(IStatementObject a, Type typeofa, JsonSerializationContext context) {
        return a.serialize();
    }
}

