/*
 * Decompiled with CFR 0.152.
 */
package gov.adlnet.xapi.model.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import gov.adlnet.xapi.model.Actor;
import gov.adlnet.xapi.model.Agent;
import gov.adlnet.xapi.model.Group;
import java.lang.reflect.Type;

public class ActorAdapter
implements JsonDeserializer<Actor>,
JsonSerializer<Actor> {
    private static final String OBJECT_TYPE = "objectType";

    public Actor deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        Class<?> klass = null;
        try {
            if (obj.has(OBJECT_TYPE)) {
                String objectType = obj.get(OBJECT_TYPE).getAsJsonPrimitive().getAsString().toLowerCase();
                if (objectType.equals("Agent".toLowerCase())) {
                    klass = Class.forName(Agent.class.getCanonicalName());
                } else if (objectType.equals("Group".toLowerCase())) {
                    klass = Class.forName(Group.class.getCanonicalName());
                }
            } else {
                klass = Class.forName(Agent.class.getCanonicalName());
            }
        }
        catch (ClassNotFoundException e) {
            throw new JsonParseException(e.getMessage());
        }
        return (Actor)context.deserialize(json, klass);
    }

    public JsonElement serialize(Actor a, Type typeofa, JsonSerializationContext context) {
        return a.serialize();
    }
}

