/*
 * Decompiled with CFR 0.152.
 */
package gov.adlnet.xapi.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gov.adlnet.xapi.model.Actor;
import gov.adlnet.xapi.model.Attachment;
import gov.adlnet.xapi.model.Context;
import gov.adlnet.xapi.model.IStatementObject;
import gov.adlnet.xapi.model.Result;
import gov.adlnet.xapi.model.Verb;
import java.util.ArrayList;

public class SubStatement
implements IStatementObject {
    public static final String SUB_STATEMENT = "SubStatement";
    private String timestamp;
    private Verb verb;
    private Actor actor;
    private IStatementObject object;
    private Result result;
    private Context context;
    private ArrayList<Attachment> attachments;

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public ArrayList<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(ArrayList<Attachment> attachments) {
        this.attachments = attachments;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Verb getVerb() {
        return this.verb;
    }

    public void setVerb(Verb verb) {
        this.verb = verb;
    }

    public Actor getActor() {
        return this.actor;
    }

    public void setActor(Actor actor) {
        this.actor = actor;
    }

    public IStatementObject getObject() {
        return this.object;
    }

    public void setObject(IStatementObject object) {
        if (object.getObjectType().toLowerCase().equals("substatement")) {
            throw new IllegalArgumentException("Sub-Statements cannot be nested");
        }
        this.object = object;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    @Override
    public String getObjectType() {
        return SUB_STATEMENT;
    }

    @Override
    public JsonElement serialize() {
        JsonObject obj = new JsonObject();
        if (this.timestamp != null) {
            obj.addProperty("timestamp", this.timestamp);
        }
        if (this.actor != null) {
            obj.add("actor", this.actor.serialize());
        }
        if (this.verb != null) {
            obj.add("verb", this.verb.serialize());
        }
        if (this.object != null) {
            obj.add("object", this.object.serialize());
        }
        if (this.result != null) {
            obj.add("result", this.result.serialize());
        }
        if (this.context != null) {
            obj.add("context", this.context.serialize());
        }
        obj.addProperty("objectType", this.getObjectType());
        JsonArray jsonAttachments = new JsonArray();
        obj.add("attachments", (JsonElement)jsonAttachments);
        for (Attachment a : this.attachments) {
            jsonAttachments.add(a.serialize());
        }
        return obj;
    }
}

