/*
 * Decompiled with CFR 0.152.
 */
package gov.adlnet.xapi.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import gov.adlnet.xapi.client.BaseClient;
import gov.adlnet.xapi.model.Actor;
import gov.adlnet.xapi.model.Statement;
import gov.adlnet.xapi.model.StatementResult;
import gov.adlnet.xapi.model.Verb;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.bouncycastle.util.encoders.Hex;

public class StatementClient
extends BaseClient {
    private TreeMap<String, String> filters;
    private static final String LINE_FEED = "\r\n";

    public StatementClient(String uri, String user, String password) throws MalformedURLException {
        super(new URL(uri), user, password);
    }

    public StatementClient(URL uri, String user, String password) throws MalformedURLException {
        super(uri, user, password);
    }

    protected HttpURLConnection initializeConnectionForAttachments(URL url, String boundary) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoInput(true);
        conn.addRequestProperty("X-Experience-API-Version", "1.0.0");
        conn.setRequestProperty("Content-Type", "multipart/mixed; boundary=" + boundary);
        conn.setRequestProperty("Authorization", this.authString);
        conn.setUseCaches(false);
        return conn;
    }

    protected HttpURLConnection initializePOSTConnectionForAttachments(URL url, String boundary) throws IOException {
        HttpURLConnection conn = this.initializeConnectionForAttachments(url, boundary);
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String issuePostWithFileAttachment(String path, String data, String contentType, ArrayList<byte[]> attachmentData) throws IOException, NoSuchAlgorithmException {
        String boundary = "===" + System.currentTimeMillis() + "===";
        URL url = new URL(this._host.getProtocol(), this._host.getHost(), this._host.getPort(), this._host.getPath() + path);
        HttpURLConnection conn = this.initializePOSTConnectionForAttachments(url, boundary);
        OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
        try {
            writer.append("--" + boundary).append(LINE_FEED);
            writer.append("Content-Type:application/json").append(LINE_FEED).append(LINE_FEED);
            writer.append(data).append(LINE_FEED);
            writer.append("--" + boundary).append(LINE_FEED);
            for (byte[] ba : attachmentData) {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                md.update(ba);
                String sha256String = new String(Hex.encode((byte[])md.digest()));
                writer.append("Content-Type:" + contentType).append(LINE_FEED);
                writer.append("Content-Transfer-Encoding:binary").append(LINE_FEED);
                writer.append("X-Experience-API-Hash:" + sha256String).append(LINE_FEED).append(LINE_FEED);
                writer.append(ba.toString()).append(LINE_FEED);
                writer.append("--" + boundary + "--");
            }
            writer.flush();
        }
        catch (IOException ex) {
            InputStream s = conn.getErrorStream();
            InputStreamReader isr = new InputStreamReader(s);
            BufferedReader br = new BufferedReader(isr);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    System.out.print(line);
                }
                System.out.println();
            }
            finally {
                s.close();
            }
            throw ex;
        }
        finally {
            writer.close();
        }
        try {
            String string = this.readFromConnection(conn);
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    public String postStatement(Statement statement) throws IOException {
        Gson gson = this.getDecoder();
        String json = gson.toJson((Object)statement);
        String result = this.issuePost("/statements", json);
        JsonArray jsonResult = (JsonArray)gson.fromJson(result, JsonArray.class);
        return jsonResult.get(0).getAsString();
    }

    public Boolean putStatement(Statement statement, String stmtId) throws IOException {
        Gson gson = this.getDecoder();
        String json = gson.toJson((Object)statement);
        String result = this.issuePut("/statements?statementId=" + stmtId, json);
        return result.isEmpty();
    }

    public String postStatementWithAttachment(Statement statement, String contentType, ArrayList<byte[]> attachmentData) throws IOException, NoSuchAlgorithmException {
        Gson gson = this.getDecoder();
        String json = gson.toJson((Object)statement);
        String result = this.issuePostWithFileAttachment("/statements", json, contentType, attachmentData);
        JsonArray jsonResult = (JsonArray)gson.fromJson(result, JsonArray.class);
        return jsonResult.get(0).getAsString();
    }

    public StatementResult getStatements(String more) throws IOException {
        String result = this.issueGet(more);
        return (StatementResult)this.getDecoder().fromJson(result, StatementResult.class);
    }

    public StatementResult getStatements() throws IOException {
        StringBuilder query = new StringBuilder();
        query.append("/statements");
        if (this.filters != null && !this.filters.isEmpty()) {
            query.append("?");
            for (Map.Entry<String, String> item : this.filters.entrySet()) {
                query.append(item.getKey());
                query.append("=");
                query.append(item.getValue());
                query.append("&");
            }
            query.deleteCharAt(query.length() - 1);
            this.filters.clear();
        }
        String result = this.issueGet(query.toString());
        return (StatementResult)this.getDecoder().fromJson(result, StatementResult.class);
    }

    public String getStatementsWithAttachments() throws IOException {
        StringBuilder query = new StringBuilder();
        query.append("/statements");
        if (this.filters != null && !this.filters.isEmpty()) {
            query.append("?");
            for (Map.Entry<String, String> item : this.filters.entrySet()) {
                query.append(item.getKey());
                query.append("=");
                query.append(item.getValue());
                query.append("&");
            }
            query.deleteCharAt(query.length() - 1);
            this.filters.clear();
        }
        if (query.toString().contains("?")) {
            query.append("&attachments=true");
        } else {
            query.append("?attachments=true");
        }
        return this.issueGet(query.toString());
    }

    public Statement get(String statementId) throws IOException {
        String result = this.issueGet("/statements?statementId=" + statementId);
        return (Statement)this.getDecoder().fromJson(result, Statement.class);
    }

    public Statement getVoided(String statementId) throws IOException {
        String result = this.issueGet("/statements?voidedStatementId=" + statementId);
        return (Statement)this.getDecoder().fromJson(result, Statement.class);
    }

    private StatementClient addFilter(String key, String value) {
        try {
            StatementClient client = new StatementClient(this._host, this.username, this.password);
            if (client.filters == null) {
                client.filters = new TreeMap();
            }
            if (this.filters != null) {
                for (Map.Entry<String, String> filter : this.filters.entrySet()) {
                    client.filters.put(filter.getKey(), filter.getValue());
                }
            }
            client.filters.put(key, value);
            return client;
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public StatementClient filterByVerb(Verb v) throws UnsupportedEncodingException {
        return this.addFilter("verb", URLEncoder.encode(v.getId(), "UTF-8"));
    }

    public StatementClient filterByVerb(String verbId) {
        return this.addFilter("verb", verbId);
    }

    public StatementClient filterByActor(Actor a) throws UnsupportedEncodingException {
        return this.addFilter("agent", URLEncoder.encode(this.getDecoder().toJson(a.serialize()), "UTF-8"));
    }

    public StatementClient filterByActivity(String activityId) {
        return this.addFilter("activity", activityId);
    }

    public StatementClient filterByRegistration(String registrationId) {
        return this.addFilter("registration", registrationId);
    }

    public StatementClient includeRelatedActivities(boolean include) {
        if (include) {
            return this.addFilter("related_activities", "true");
        }
        return this.addFilter("related_activities", "false");
    }

    public StatementClient includeRelatedAgents(boolean include) {
        if (include) {
            return this.addFilter("related_agents", "true");
        }
        return this.addFilter("related_agents", "false");
    }

    public StatementClient filterBySince(String timestamp) {
        return this.addFilter("since", timestamp);
    }

    public StatementClient limitResults(int limit) {
        return this.addFilter("limit", Integer.toString(limit));
    }

    public StatementClient filterByUntil(String timestamp) {
        return this.addFilter("until", timestamp);
    }

    public StatementClient exact() {
        return this.addFilter("format", "exact");
    }

    public StatementClient ids() {
        return this.addFilter("format", "ids");
    }

    public StatementClient canonical() {
        return this.addFilter("format", "canonical");
    }

    public StatementClient ascending(boolean include) {
        if (include) {
            return this.addFilter("ascending", "true");
        }
        return this.addFilter("ascending", "false");
    }
}

