/*
 * Decompiled with CFR 0.152.
 */
package gov.adlnet.xapi.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import gov.adlnet.xapi.model.Actor;
import gov.adlnet.xapi.model.IStatementObject;
import gov.adlnet.xapi.model.adapters.ActorAdapter;
import gov.adlnet.xapi.model.adapters.StatementObjectAdapter;
import gov.adlnet.xapi.util.Base64;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletResponse;

public class BaseClient {
    protected URL _host;
    protected Gson gson;
    protected String username;
    protected String password;
    protected String authString;

    public BaseClient(String uri, String username, String password) throws MalformedURLException {
        this.init(new URL(uri), username, password);
    }

    public BaseClient(URL uri, String username, String password) throws MalformedURLException {
        this.init(uri, username, password);
    }

    protected Gson getDecoder() {
        if (this.gson == null) {
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeAdapter(Actor.class, (Object)new ActorAdapter());
            builder.registerTypeAdapter(IStatementObject.class, (Object)new StatementObjectAdapter());
            this.gson = builder.create();
        }
        return this.gson;
    }

    protected void init(URL uri, String user, String password) throws MalformedURLException {
        URL newUri;
        String holder = uri.toString();
        this._host = holder.endsWith("/") ? (newUri = new URL(holder.substring(0, holder.length() - 1))) : uri;
        this.username = user;
        this.password = password;
        this.authString = "Basic " + Base64.encodeToString((this.username + ":" + this.password).getBytes(), 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readFromConnection(HttpURLConnection conn) throws IOException {
        if (conn.getResponseCode() >= 400) {
            String server = conn.getURL().toString();
            int statusCode = conn.getResponseCode();
            BufferedInputStream in = new BufferedInputStream(conn.getErrorStream());
            StringBuilder sb = new StringBuilder();
            InputStreamReader reader = new InputStreamReader(in);
            BufferedReader br = new BufferedReader(reader);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (Throwable throwable) {
                throw new IOException(String.format("Server (%s) Responded with %d: %s", server, statusCode, sb.toString()));
            }
            throw new IOException(String.format("Server (%s) Responded with %d: %s", server, statusCode, sb.toString()));
        }
        BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
        StringBuilder sb = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(in);
        BufferedReader br = new BufferedReader(reader);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            br.close();
            reader.close();
        }
    }

    protected HttpURLConnection initializeConnection(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoInput(true);
        conn.addRequestProperty("X-Experience-API-Version", "1.0.0");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Authorization", this.authString);
        return conn;
    }

    protected HttpURLConnection initializePOSTConnection(URL url) throws IOException {
        HttpURLConnection conn = this.initializeConnection(url);
        conn.setDoOutput(true);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String issuePost(String path, String data) throws IOException {
        URL url = new URL(this._host.getProtocol(), this._host.getHost(), this._host.getPort(), this._host.getPath() + path);
        HttpURLConnection conn = this.initializePOSTConnection(url);
        conn.setRequestMethod("POST");
        OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
        try {
            writer.write(data);
        }
        catch (IOException ex) {
            InputStream s = conn.getErrorStream();
            InputStreamReader isr = new InputStreamReader(s);
            BufferedReader br = new BufferedReader(isr);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    System.out.print(line);
                }
                System.out.println();
            }
            finally {
                s.close();
            }
            throw ex;
        }
        finally {
            writer.close();
        }
        try {
            String string = this.readFromConnection(conn);
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String issuePut(String path, String data) throws IOException {
        URL url = new URL(this._host.getProtocol(), this._host.getHost(), this._host.getPort(), this._host.getPath() + path);
        HttpURLConnection conn = this.initializePOSTConnection(url);
        conn.setRequestMethod("PUT");
        OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
        try {
            writer.write(data);
        }
        catch (IOException ex) {
            InputStream s = conn.getErrorStream();
            InputStreamReader isr = new InputStreamReader(s);
            BufferedReader br = new BufferedReader(isr);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    System.out.print(line);
                }
                System.out.println();
            }
            finally {
                s.close();
            }
            throw ex;
        }
        finally {
            writer.close();
        }
        try {
            String string = this.readFromConnection(conn);
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String issueDelete(String path) throws IOException {
        URL url = new URL(this._host.getProtocol(), this._host.getHost(), this._host.getPort(), this._host.getPath() + path);
        HttpURLConnection conn = this.initializeConnection(url);
        conn.setRequestMethod("DELETE");
        try {
            String string = this.readFromConnection(conn);
            return string;
        }
        catch (IOException ex) {
            InputStream s = conn.getErrorStream();
            InputStreamReader isr = new InputStreamReader(s);
            BufferedReader br = new BufferedReader(isr);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    System.out.print(line);
                }
                System.out.println();
            }
            finally {
                s.close();
            }
            throw ex;
        }
        finally {
            conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String issueGet(String path) throws IOException {
        String fixedPath = this.checkPath(path);
        URL url = new URL(this._host.getProtocol(), this._host.getHost(), this._host.getPort(), this._host.getPath() + fixedPath);
        HttpURLConnection conn = this.initializeConnection(url);
        try {
            String string = this.readFromConnection(conn);
            return string;
        }
        catch (IOException ex) {
            InputStream s = conn.getErrorStream();
            InputStreamReader isr = new InputStreamReader(s);
            BufferedReader br = new BufferedReader(isr);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    System.out.print(line);
                }
                System.out.println();
            }
            finally {
                s.close();
            }
            throw ex;
        }
        finally {
            conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpServletResponse issueGetWithAttachments(String path) throws IOException {
        URL url = new URL(this._host.getProtocol(), this._host.getHost(), this._host.getPort(), path);
        HttpURLConnection conn = this.initializeConnection(url);
        try {
            HttpServletResponse httpServletResponse = (HttpServletResponse)conn.getInputStream();
            return httpServletResponse;
        }
        catch (IOException ex) {
            InputStream s = conn.getErrorStream();
            InputStreamReader isr = new InputStreamReader(s);
            BufferedReader br = new BufferedReader(isr);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    System.out.print(line);
                }
                System.out.println();
            }
            finally {
                s.close();
            }
            throw ex;
        }
        finally {
            conn.disconnect();
        }
    }

    protected String checkPath(String path) {
        if (path.toLowerCase().contains("statements") && path.toLowerCase().contains("more")) {
            int pathLength = this._host.getPath().length();
            return path.substring(pathLength, path.length());
        }
        return path;
    }
}

