/*
 * Decompiled with CFR 0.152.
 */
package gov.adlnet.xapi.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gov.adlnet.xapi.client.BaseClient;
import gov.adlnet.xapi.model.Activity;
import gov.adlnet.xapi.model.ActivityProfile;
import gov.adlnet.xapi.model.ActivityState;
import gov.adlnet.xapi.model.Agent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.UUID;

public class ActivityClient
extends BaseClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String issueProfilePost(String path, String data, HashMap<String, String> etag) throws IOException {
        URL url = new URL(this._host.getProtocol(), this._host.getHost(), this._host.getPath() + path);
        HttpURLConnection conn = this.initializePOSTConnection(url);
        if (etag.containsKey("If-Match")) {
            conn.addRequestProperty("If-Match", etag.get("If-Match"));
        } else {
            conn.addRequestProperty("If-None-Match", etag.get("If-None-Match"));
        }
        conn.setRequestMethod("POST");
        OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
        try {
            writer.write(data);
        }
        catch (IOException ex) {
            InputStream s = conn.getErrorStream();
            InputStreamReader isr = new InputStreamReader(s);
            BufferedReader br = new BufferedReader(isr);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    System.out.print(line);
                }
                System.out.println();
            }
            finally {
                s.close();
            }
            throw ex;
        }
        finally {
            writer.close();
        }
        try {
            String string = this.readFromConnection(conn);
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String issueProfilePut(String path, String data, HashMap<String, String> etag) throws IOException {
        URL url = new URL(this._host.getProtocol(), this._host.getHost(), this._host.getPath() + path);
        HttpURLConnection conn = this.initializePOSTConnection(url);
        if (etag.containsKey("If-Match")) {
            conn.addRequestProperty("If-Match", etag.get("If-Match"));
        } else {
            conn.addRequestProperty("If-None-Match", etag.get("If-None-Match"));
        }
        conn.setRequestMethod("PUT");
        OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
        try {
            writer.write(data);
        }
        catch (IOException ex) {
            InputStream s = conn.getErrorStream();
            InputStreamReader isr = new InputStreamReader(s);
            BufferedReader br = new BufferedReader(isr);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    System.out.print(line);
                }
                System.out.println();
            }
            finally {
                s.close();
            }
            throw ex;
        }
        finally {
            writer.close();
        }
        try {
            String string = this.readFromConnection(conn);
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String issueProfileDelete(String path, String ifMatchEtagValue) throws IOException {
        URL url = new URL(this._host.getProtocol(), this._host.getHost(), this._host.getPath() + path);
        HttpURLConnection conn = this.initializeConnection(url);
        conn.addRequestProperty("If-Match", ifMatchEtagValue);
        conn.setRequestMethod("DELETE");
        try {
            String string = this.readFromConnection(conn);
            return string;
        }
        catch (IOException ex) {
            InputStream s = conn.getErrorStream();
            InputStreamReader isr = new InputStreamReader(s);
            BufferedReader br = new BufferedReader(isr);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    System.out.print(line);
                }
                System.out.println();
            }
            finally {
                s.close();
            }
            throw ex;
        }
        finally {
            conn.disconnect();
        }
    }

    public ActivityClient(String uri, String username, String password) throws MalformedURLException {
        super(uri, username, password);
    }

    public ActivityClient(URL uri, String username, String password) throws MalformedURLException {
        super(uri, username, password);
    }

    public Activity getActivity(String activityId) throws IOException {
        String path = "/activities?activityId=" + activityId;
        String result = this.issueGet(path);
        return (Activity)this.getDecoder().fromJson(result, Activity.class);
    }

    private String createProfilePath(ActivityProfile activityProfile) {
        StringBuilder sb = new StringBuilder();
        sb.append("/activities/profile?activityId=");
        sb.append(activityProfile.getActivityId());
        sb.append("&profileId=");
        sb.append(activityProfile.getProfileId());
        return sb.toString();
    }

    public JsonObject getActivityProfile(ActivityProfile activityProfile) throws IOException {
        String result = this.issueGet(this.createProfilePath(activityProfile));
        return (JsonObject)this.getDecoder().fromJson(result, JsonObject.class);
    }

    public boolean postActivityProfile(ActivityProfile activityProfile, HashMap<String, String> etag) throws IOException {
        String json = this.getDecoder().toJson((JsonElement)activityProfile.getProfile());
        String response = this.issueProfilePost(this.createProfilePath(activityProfile), json, etag);
        return response.isEmpty();
    }

    public boolean putActivityProfile(ActivityProfile activityProfile, HashMap<String, String> etag) throws IOException {
        String json = this.getDecoder().toJson((JsonElement)activityProfile.getProfile());
        String response = this.issueProfilePut(this.createProfilePath(activityProfile), json, etag);
        return response.isEmpty();
    }

    public boolean deleteActivityProfile(ActivityProfile activityProfile, String ifMatchEtagValue) throws IOException {
        String response = this.issueProfileDelete(this.createProfilePath(activityProfile), ifMatchEtagValue);
        return response.isEmpty();
    }

    public JsonArray getActivityProfiles(String activityId, String since) throws IOException {
        String path = "/activities/profile?activityId=" + activityId;
        if (since != null && since.length() > 0) {
            path = path + "&since=" + since;
        }
        String result = this.issueGet(path);
        return (JsonArray)this.getDecoder().fromJson(result, JsonArray.class);
    }

    private String createStatePath(ActivityState activityState) {
        StringBuilder sb = new StringBuilder();
        sb.append("/activities/state?activityId=");
        sb.append(activityState.getActivityId());
        sb.append("&stateId=");
        sb.append(activityState.getStateId());
        sb.append("&agent=");
        sb.append(this.getDecoder().toJson((Object)activityState.getAgent()));
        UUID reg = activityState.getRegistration();
        if (reg != null) {
            sb.append("&registration=" + reg.toString());
        }
        return sb.toString();
    }

    public JsonObject getActivityState(ActivityState activityState) throws IOException {
        String result = this.issueGet(this.createStatePath(activityState));
        return (JsonObject)this.getDecoder().fromJson(result, JsonObject.class);
    }

    public boolean postActivityState(ActivityState activityState) throws IOException {
        String json = this.getDecoder().toJson((JsonElement)activityState.getState());
        String result = this.issuePost(this.createStatePath(activityState), json);
        return result.isEmpty();
    }

    public boolean putActivityState(ActivityState activityState) throws IOException {
        String json = this.getDecoder().toJson((JsonElement)activityState.getState());
        String result = this.issuePut(this.createStatePath(activityState), json);
        return result.isEmpty();
    }

    public boolean deleteActivityState(ActivityState activityState) throws IOException {
        String result = this.issueDelete(this.createStatePath(activityState));
        return result.isEmpty();
    }

    public JsonArray getActivityStates(String activityId, Agent agent, String registration, String since) throws IOException {
        String path = String.format("/activities/state?activityId=%s&agent=%s", activityId, this.getDecoder().toJson(agent.serialize()));
        if (registration != null && registration.length() > 0) {
            path = path + "&registration=" + registration;
        }
        if (since != null && since.length() > 0) {
            path = path + "&since=" + since;
        }
        String result = this.issueGet(path);
        return (JsonArray)this.getDecoder().fromJson(result, JsonArray.class);
    }

    public boolean deleteActivityStates(String activityId, Agent agent, String registration) throws IOException {
        String path = String.format("/activities/state?activityId=%s&agent=%s", activityId, this.getDecoder().toJson(agent.serialize()));
        if (registration != null && registration.length() > 0) {
            path = path + "&registration=" + registration;
        }
        String result = this.issueDelete(path);
        return result.isEmpty();
    }
}

