package com.unitypay.billingmodule

import android.app.Activity
import android.util.Log
import com.android.billingclient.api.BillingClient
import com.android.billingclient.api.BillingClient.SkuType.INAPP
import com.android.billingclient.api.Purchase
import com.unitypay.billingmodule.BillingToClient.BillingResponse.OK
import com.unitypay.billingmodule.PayReport.BILLING_ERROR
import com.unitypay.billingmodule.PayReport.PURCHASES_CODE
import com.unitypay.billingmodule.PayReport.START_PROCESSER

import com.unitypay.billingmodule.billing.BillingManager


class PayManager(var act: Activity) {

    private var runnable: Runnable? = null
    private var serviceEnable = false
    var callback: UnityPayInter? = null
    val reportMessage: PayResultBean = PayResultBean()
    var fileUtils = FileUtils()
    var buyThirdId = ""
    var billingType = ""

    protected var billingManager = BillingManager(act, object : BillingManager.BillingUpdatesListener {
        override fun googleError(code: Int) {
            PayReport.report(BILLING_ERROR, errorcode = code.toString())
            when (code) {
                3 -> onFail("error code = 3")
                9 -> onFail("error code = 9")
            }
            hideLoading()

        }

        override fun onPurchasesCode(code: Int?) {
            PayReport.report(PURCHASES_CODE, errorcode = code.toString())
            if (code == BillingClient.BillingResponse.USER_CANCELED) {
                onUserCancel(code.toString())
            } else {
                onBuyFail(reportMessage, code.toString())
            }
        }

        override fun onBillingClientSetupFinished() {
            serviceEnable = true
            runnable?.let {
                CrushExecuter.mMainThread.execute(it)
            }
        }

        override fun onConsumeFinished(token: String?, result: Int) {
            if (result == OK) {
                onBuySuccess("final consume success")
            } else {
                FileUtils().writeFileData(act, token ?: "");
                onBuySuccess("final consume faile ,result = $result; tolen = $token")
            }
        }

        override fun onPurchasesUpdated(purchases: MutableList<Purchase>?) {
            reportAndLog("onPurchasesUpdated")
            purchases?.let {
                for (pur in it) {
                    val token = pur.sku
                    if (token == buyThirdId) {
                        if (billingType == INAPP) {
                            serviceCallBack(pur)
                            return //为了不让下一次循环走了phase2
                        } else {
                            serviceCallBack(pur)
                        }
                    }
                }
                if (phase == 0 && billingType == INAPP) {
                    phase = 1
                    gotoPay(buyThirdId, billingType)
                }
            }
            showLoading()
        }
    })

    fun consume(token: String) {
        billingManager.consumeAsync(token)
    }

    open fun initalize(callback: UnityPayInterBase) {
        this.callback = callback
        showLoading()
        initUtils()
//        checkLastFaile()
        PayReport.generateBuySession()
        PayReport.report(START_PROCESSER)
        reportAndLog(START_PROCESSER)
        runnable = Runnable {
            showLoading()
        }
        if (serviceEnable) {
            CrushExecuter.mMainThread.execute(runnable)
        } else {
            hideLoading()
        }
    }

    private fun initUtils() {
        val config = act.getResources().getConfiguration()
        PayInfoUtils.aid = android.provider.Settings.Secure.getString(
            act.getContentResolver(),
            android.provider.Settings.Secure.ANDROID_ID
        )
        PayInfoUtils.mcc = config.mcc.toString()
        PayInfoUtils.mnc = config.mnc.toString()
        PayInfoUtils.cl = config.locale.language
        PayInfoUtils.ver = act.getPackageManager().getPackageInfo(act.getPackageName(), 0).versionName
        PayInfoUtils.sdkver = act.getPackageManager().getPackageInfo(act.getPackageName(), 0).versionCode.toString()

    }

    private fun checkLastFaile() {
        val faileToken = fileUtils.getFaileToken(act)
        if (faileToken.isNotEmpty()) {
//
        }
    }

    var phase = 0
    fun gotoPay(thridis: String, @BillingClient.SkuType billingType: String) {
        this.buyThirdId = thridis
        this.billingType = billingType
        if (phase == 0) {
            billingManager.queryPurchases()
        } else {
            reportAndLog("ready buy $thridis")
            showLoading()
            PayReport.report(PayReport.ORDER_DONE)
            billingManager.initiatePurchaseFlow(thridis, null, billingType)
        }
    }


    fun serviceCallBack(pur: Purchase) {
        PayReport.report(PayReport.ORDER_CALLBACK)
        reportAndLog("callback")
        val postPara = hashMapOf<String, String>()
        postPara.put("product_id", pur.sku)
        postPara.put("pid", "KyE90RXNzBHeeZ4b")
        postPara.put("third_trade_no", pur.orderId)
        postPara.put("receipt_data", pur.originalJson)
        HttpsUtils().setUrl("http://qa.play.cheez.com/pay/callback4android")
            .requestPost(postPara, object : HttpsUtils.HttpCallBack {
                override fun success(result: String) {
                    if (billingType == INAPP) {
                        consume(pur.purchaseToken)
                    }
                }

                override fun faile(result: String) {

                }
            })
    }

    fun onSuccess(message: String = "") {
        phase = 0
        PayReport.report(PayReport.FINAL_SUCCESS, message = message)
        callback?.onSuccess(message)
        reportAndLog(message)
        hideLoading()

    }

    fun onBuySuccess(message: String = "") {
        phase = 0
        PayReport.report(PayReport.FINAL_BUY_SUCCESS, message = message)
        callback?.onFail(message)
        reportAndLog(message)
        hideLoading()
    }

    fun onFail(message: String = "") {
        phase = 0
        callback?.onFail(message)
        PayReport.report(PayReport.FINAL_FAIL, message = message)
        reportAndLog(message)
        hideLoading()
    }

    fun onBuyFail(payResultBean: PayResultBean, message: String = "") {
        phase = 0
        callback?.onFail(message)
        PayReport.report(PayReport.FINAL_BUY_FAIL, message = message)
        hideLoading()
    }

    fun showLoading() {
        callback?.showLoading()
    }

    fun hideLoading() {
        callback?.hideLoading()
    }

    fun reportAndLog(message: String) {
        Log.d("unitypaytoto", message)
    }

    fun onUserCancel(message: String = "") {
        callback?.onUserCancel()
        hideLoading()
    }

    fun queryBilling() {
        billingManager.queryPurchases()
    }
}