package com.unitypay.billingmodule

import android.content.ContentValues.TAG
import android.os.Build
import android.util.Log
import java.io.ByteArrayOutputStream
import java.io.DataOutputStream
import java.io.InputStream
import java.io.OutputStream
import java.lang.RuntimeException
import java.net.HttpURLConnection
import java.net.URL
import java.net.URLEncoder
import java.util.*
import kotlin.collections.HashMap


class HttpsUtils {

    var httpUrl: String = ""

    interface HttpCallBack {
        fun success(result: String)
        fun faile(result: String)
    }

    fun setUrl(url: String): HttpsUtils {
        httpUrl = url
        return this
    }

    fun requestPost(paramsMap: HashMap<String, String>, callback: HttpCallBack) {
        val data = HashMap<String, String>()
        data.put("Content-Type", "application/json")
        data.put("mcc", PayInfoUtils.mcc)
        data.put("mnc", PayInfoUtils.mnc)
        data.put("did", PayInfoUtils.aid)
        data.put("brand", Build.BRAND)
        data.put("model", Build.MODEL)
        data.put("cl", PayInfoUtils.cl)
        data.put("apilevel", Build.VERSION.SDK_INT.toString())
        data.put("ver", PayInfoUtils.ver)
        data.put("sdkver", PayInfoUtils.sdkver)
        requestPostBase(data, paramsMap, callback)


    }


    fun requestPostBase(data: HashMap<String, String>, paramsMap: HashMap<String, String>, callback: HttpCallBack) {
        CrushExecuter.mNetworkIO.execute {
            try {
                if (httpUrl.isEmpty()) {
                    throw RuntimeException("unitysdk url is empty , please call setUrl() first")
                }
                //合成参数
                val params = mapToString(data)
                // 请求的参数转换为byte数组
                // 新建一个URL对象
                val url = URL("$httpUrl?$params")
                // 打开一个HttpURLConnection连接
                val urlConn = url.openConnection() as HttpURLConnection
                // 设置连接超时时间
                urlConn.setConnectTimeout(5 * 1000)
                //设置从主机读取数据超时
                urlConn.setReadTimeout(5 * 1000)
                // Post请求必须设置允许输出 默认false
                urlConn.setDoOutput(true)
                //设置请求允许输入 默认是true
                urlConn.setDoInput(true)
                // Post请求不能使用缓存
                urlConn.setUseCaches(false)
                // 设置为Post请求
                urlConn.setRequestMethod("POST")
                //设置本次连接是否自动处理重定向
                urlConn.setInstanceFollowRedirects(true)
                // 配置请求Content-Type
                urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded")

                // 开始连接
                urlConn.connect()
                // 发送请求参数
                val dos = DataOutputStream(urlConn.getOutputStream())
                val postPara = mapToString(paramsMap).toString().toByteArray()
                dos.write(postPara)
                dos.flush()
                dos.close()
                // 判断请求是否成功
                val result = streamToString(urlConn.getInputStream())

                if (urlConn.getResponseCode() === 200) {
                    // 获取返回的数据
                    callback.success(result)
                    Log.e(TAG, "Post方式请求成功，result--->$result")
                } else {
                    callback.faile(result)
                    Log.e(TAG, "Post方式请求失败")
                }
                // 关闭连接
                urlConn.disconnect()
            } catch (e: Exception) {
                Log.e(TAG, e.toString())
            }
        }

    }


    fun mapToString(map: HashMap<String, String>): String {
        val tempParams = StringBuilder()
        var pos = 0
        for (key in map.keys) {
            if (pos > 0) {
                tempParams.append("&")
            }
            tempParams.append(String.format("%s=%s", key, URLEncoder.encode(map[key], "utf-8")))
            pos++
        }
        return tempParams.toString()
    }

    /**
     * 将输入流转换成字符串
     *
     * @param is 从网络获取的输入流
     * @return
     */
    fun streamToString(`in`: InputStream): String {
        var output = ByteArrayOutputStream()
        try {
            var read: Int = -1
            `in`.use { input ->
                output.use {
                    while (input.read().also { read = it } != -1) {
                        it.write(read)

                    }
                }
            }
        } catch (t: Throwable) {
            t.printStackTrace()
        }
        return String(output.toByteArray())
    }


}