package com.unitypay.billingmodule

import android.app.Activity
import android.util.Log
import com.android.billingclient.api.BillingClient
import com.android.billingclient.api.BillingClient.SkuType.INAPP
import com.android.billingclient.api.Purchase
import com.unitypay.billingmodule.BillingToClient.BillingResponse.OK
import com.unitypay.billingmodule.PayReport.BILLING_ERROR
import com.unitypay.billingmodule.PayReport.PURCHASES_CODE
import com.unitypay.billingmodule.PayReport.START_PROCESSER

import com.unitypay.billingmodule.billing.BillingManager


class PayManager(var act: Activity) {

    private var runnable: Runnable? = null
    private var serviceEnable = false
    var callback: UnityPayInter? = null
    val reportMessage: PayResultBean = PayResultBean()
    var fileUtils = FileUtils()
    var buyThirdId = ""
    var billingType = ""

    protected var billingManager = BillingManager(act, object : BillingManager.BillingUpdatesListener {
        override fun googleError(code: Int) {
            PayReport.report(BILLING_ERROR, errorcode = code.toString())
            when (code) {
                3 -> onFail("error code = 3")
                9 -> onFail("error code = 9")
            }
            hideLoading()

        }

        override fun onPurchasesCode(code: Int?) {
            PayReport.report(PURCHASES_CODE, errorcode = code.toString())
            if (code == BillingClient.BillingResponse.USER_CANCELED) {
                onUserCancel(code.toString())
            } else {
                onBuyFail(reportMessage, code.toString())
            }
        }

        override fun onBillingClientSetupFinished() {
            serviceEnable = true
            runnable?.let {
                CrushExecuter.mMainThread.execute(it)
            }
        }

        override fun onConsumeFinished(token: String?, result: Int) {
            if (result == OK) {
                serviceCallBack(token ?: "")
                onBuySuccess("final consume success")
            } else {
                FileUtils().writeFileData(act, token ?: "");
                onBuySuccess("final consume faile ,result = $result; tolen = $token")
            }
        }

        override fun onPurchasesUpdated(purchases: MutableList<Purchase>?) {
            reportAndLog("onPurchasesUpdated")
            purchases?.let {
                for (pur in it) {
                    val token = pur.sku
                    if (token == buyThirdId) {
                        if (billingType == INAPP) {
                            consume(token)
                        } else {
                            serviceCallBack(token)
                        }
                    }
                }
            }

            showLoading()

        }
    })

    fun consume(token: String) {
        billingManager.consumeAsync(token)
    }

    open fun initalize(callback: UnityPayInterBase) {
        this.callback = callback
        showLoading()
        checkLastFaile()
        PayReport.generateBuySession()
        PayReport.report(START_PROCESSER)
        reportAndLog(START_PROCESSER)
        runnable = Runnable {
            showLoading()
        }
        if (serviceEnable) {
            CrushExecuter.mMainThread.execute(runnable)
        } else {
            hideLoading()
        }
    }

    private fun checkLastFaile() {
//        val faileToken = fileUtils.getFaileToken(act)
//        if (faileToken.isNotEmpty()) {
//
//        }
    }

    fun gotoPay(
        thridis: String, @BillingClient.SkuType billingType: String

    ) {
        reportAndLog("ready buy $thridis")
        this.buyThirdId = thridis
        this.billingType = billingType
        showLoading()
        PayReport.report(PayReport.ORDER_DONE)
        billingManager.initiatePurchaseFlow(thridis, null, billingType)
//        initCallback(callbackname)
    }

    private fun initCallback(callbackname: String) {
        callback = object : UnityPayInterBase() {
            override fun callUnity(funName: String, para: String) {
            }
        }
    }
    fun serviceCallBack(token: String) {
        PayReport.report(PayReport.ORDER_CALLBACK)
        reportAndLog("callback")
        HttpsUtils().setUrl("").requestPost(hashMapOf(), object : HttpsUtils.HttpCallBack {
            override fun success(result: String) {

            }

            override fun faile(result: String) {

            }

        })
    }

    fun onSuccess(message: String = "") {
        PayReport.report(PayReport.FINAL_SUCCESS, message = message)
        callback?.onSuccess(message)
        reportAndLog(message)
        hideLoading()
        billingManager.destroy()

    }

    fun onBuySuccess(message: String = "") {
        PayReport.report(PayReport.FINAL_BUY_SUCCESS, message = message)
        callback?.onFail(message)
        reportAndLog(message)
        hideLoading()
        billingManager.destroy()
    }

    fun onFail(message: String = "") {
        callback?.onFail(message)
        PayReport.report(PayReport.FINAL_FAIL, message = message)
        reportAndLog(message)
        hideLoading()
        billingManager.destroy()
    }

    fun onBuyFail(payResultBean: PayResultBean, message: String = "") {
        callback?.onFail(message)
        PayReport.report(PayReport.FINAL_BUY_FAIL, message = message)
        hideLoading()
        billingManager.destroy()
    }

    fun showLoading() {
//        callback?.showLoading()
    }

    fun hideLoading() {
        callback?.hideLoading()
    }

    fun reportAndLog(message: String) {
        Log.d("unitypaytoto", message)
    }

    fun onUserCancel(message: String = "") {
        callback?.onUserCancel()
        hideLoading()
    }
}