package com.unitypay.billingmodule

abstract class UnityPayInterBase() : UnityPayInter {

    abstract fun callUnity(funName: String, para: String = "")

    override fun onSuccess(message: String) {
        callUnity("OnSuccess", message)
    }

    override fun onFail(message: String) {
        callUnity("OnFail", message)

    }

    override fun onBuyFail(payResultBean: PayResultBean, message: String) {
        callUnity("OnBuyFail", message)

    }

    override fun showLoading() {
        callUnity("ShowLoading")

    }

    override fun hideLoading() {
        callUnity("HideLoading")

    }

    override fun onUserCancel(message: String) {
        callUnity("OnUserCancel", message)
    }

    override fun googleError(code: Int) {
        callUnity("GoogleError", code.toString())
    }

    override fun onPurchasesCode(code: Int?) {
        callUnity("OnPurchasesCode", code.toString())
    }

    override fun onBillingClientSetupFinished() {
        callUnity("OnBillingClientSetupFinished")
    }

    override fun onConsumeFinished(token: String?, result: Int) {
        callUnity("OnConsumeFinished", token ?: "")
    }

    override fun onPurchasesUpdated(token: String?) {
        callUnity("OnPurchasesUpdated", token ?: "")
    }

}