/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tools.xmlbeans;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.geronimo.tools.xmlbeans.SchemaCompiler;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaCompilerWrapper {
    public static void CompileSchemas(String sourceDir, String sourceSchemas, String xmlConfigs, String targetDir, String catalogLocation, String classpath) throws Exception {
        ArrayList<File> schemas = new ArrayList<File>();
        File base = new File(sourceDir);
        StringTokenizer st = new StringTokenizer(sourceSchemas, ",");
        while (st.hasMoreTokens()) {
            String schemaName = st.nextToken();
            schemas.add(new File(base, schemaName));
        }
        ArrayList<File> configs = new ArrayList<File>();
        if (xmlConfigs != null) {
            StringTokenizer st2 = new StringTokenizer(xmlConfigs, ",");
            while (st2.hasMoreTokens()) {
                String configName = st2.nextToken();
                configs.add(new File(configName));
            }
        }
        PassThroughResolver entityResolver = null;
        if (catalogLocation != null) {
            CatalogManager catalogManager = CatalogManager.getStaticManager();
            catalogManager.setCatalogFiles(catalogLocation);
            entityResolver = new PassThroughResolver((EntityResolver)new CatalogResolver());
        }
        ArrayList<File> classPathList = new ArrayList<File>();
        if (classpath != null) {
            StringTokenizer st3 = new StringTokenizer(classpath, ",");
            while (st3.hasMoreTokens()) {
                String classpathElement = st3.nextToken();
                classPathList.add(new File(classpathElement));
            }
        }
        SchemaCompiler.Parameters params = new SchemaCompiler.Parameters();
        params.setBaseDir(null);
        params.setXsdFiles(schemas.toArray(new File[0]));
        params.setWsdlFiles(new File[0]);
        params.setJavaFiles(new File[0]);
        params.setConfigFiles(configs.toArray(new File[0]));
        params.setClasspath(classPathList.toArray(new File[0]));
        params.setOutputJar(null);
        params.setName(null);
        params.setSrcDir(new File(targetDir));
        params.setClassesDir(new File(targetDir));
        params.setCompiler(null);
        params.setJar(null);
        params.setMemoryInitialSize(null);
        params.setMemoryMaximumSize(null);
        params.setNojavac(true);
        params.setQuiet(false);
        params.setVerbose(true);
        params.setDownload(false);
        params.setNoUpa(false);
        params.setNoPvr(false);
        params.setDebug(true);
        params.setErrorListener(new ArrayList());
        params.setRepackage(null);
        params.setExtensions(null);
        params.setJaxb(false);
        params.setMdefNamespaces(null);
        params.setEntityResolver(entityResolver);
        boolean result = SchemaCompiler.compile(params);
        if (!result) {
            Collection errors = params.getErrorListener();
            Iterator iterator = errors.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                System.out.println("xmlbeans error: " + o);
            }
            throw new Exception("Schema compilation failed");
        }
    }

    private static class PassThroughResolver
    implements EntityResolver {
        private final EntityResolver delegate;

        public PassThroughResolver(EntityResolver delegate) {
            this.delegate = delegate;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            InputSource is = this.delegate.resolveEntity(publicId, systemId);
            if (is != null) {
                return is;
            }
            System.out.println("Could not resolve publicId: " + publicId + ", systemId: " + systemId + " from catalog");
            return new InputSource(systemId);
        }
    }
}

