/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.interceptor;

import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.tomcat.interceptor.BeforeAfter;

public class PolicyContextBeforeAfter
implements BeforeAfter {
    private final BeforeAfter next;
    private final String policyContextID;
    private final int policyContextIDIndex;

    public PolicyContextBeforeAfter(BeforeAfter next, int policyContextIDIndex, String policyContextID) {
        this.next = next;
        this.policyContextIDIndex = policyContextIDIndex;
        this.policyContextID = policyContextID;
    }

    public void before(Object[] context, ServletRequest httpRequest, ServletResponse httpResponse) {
        PolicyHolder policyHolder = new PolicyHolder();
        policyHolder.setContextId(PolicyContext.getContextID());
        policyHolder.setSubject(ContextManager.getCurrentCaller());
        context[this.policyContextIDIndex] = policyHolder;
        PolicyContext.setContextID((String)this.policyContextID);
        PolicyContext.setHandlerData((Object)httpRequest);
        if (this.next != null) {
            this.next.before(context, httpRequest, httpResponse);
        }
    }

    public void after(Object[] context, ServletRequest httpRequest, ServletResponse httpResponse) {
        if (this.next != null) {
            this.next.after(context, httpRequest, httpResponse);
        }
        PolicyHolder policyHolder = (PolicyHolder)context[this.policyContextIDIndex];
        PolicyContext.setContextID((String)policyHolder.getContextId());
        ContextManager.setCurrentCaller((Subject)policyHolder.getSubject());
    }

    class PolicyHolder {
        private Subject subject;
        private String contextId;

        PolicyHolder() {
        }

        public String getContextId() {
            return this.contextId;
        }

        public void setContextId(String contextId) {
            this.contextId = contextId;
        }

        public Subject getSubject() {
            return this.subject;
        }

        public void setSubject(Subject subject) {
            this.subject = subject;
        }
    }
}

