/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.cluster;

import java.util.Map;
import org.apache.catalina.cluster.MessageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.tomcat.BaseGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;

public class MessageListenerGBean
extends BaseGBean
implements GBeanLifecycle,
ObjectRetriever {
    private static final Log log = LogFactory.getLog((Class)MessageListenerGBean.class);
    public static final String J2EE_TYPE = "MessageListener";
    private final MessageListener listener;
    private final MessageListenerGBean nextListener;
    private final String className;
    public static final GBeanInfo GBEAN_INFO;

    public MessageListenerGBean() {
        this.listener = null;
        this.nextListener = null;
        this.className = null;
    }

    public MessageListenerGBean(String className, Map initParams, MessageListenerGBean nextListener) throws Exception {
        if (className == null) {
            throw new IllegalArgumentException("className cannot be null.");
        }
        if (nextListener != null) {
            if (!(nextListener.getInternalObject() instanceof MessageListener)) {
                throw new IllegalArgumentException("nextListener is not of type MessageListener.");
            }
            this.nextListener = nextListener;
        } else {
            this.nextListener = null;
        }
        this.className = className;
        this.listener = (MessageListener)Class.forName(className).newInstance();
        this.setParameters(this.listener, initParams);
    }

    public void doStart() throws Exception {
        log.debug((Object)(this.className + " started."));
    }

    public void doStop() throws Exception {
        log.debug((Object)(this.className + " stopped."));
    }

    public void doFail() {
        log.warn((Object)(this.className + " failed."));
    }

    public Object getInternalObject() {
        return this.listener;
    }

    public MessageListenerGBean getNextValve() {
        return this.nextListener;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)MessageListenerGBean.class, (String)J2EE_TYPE);
        infoFactory.addAttribute("className", String.class, true);
        infoFactory.addAttribute("initParams", Map.class, true);
        infoFactory.addReference("NextListener", MessageListenerGBean.class, J2EE_TYPE);
        infoFactory.addOperation("getInternalObject");
        infoFactory.addOperation("getNextValve");
        infoFactory.setConstructor(new String[]{"className", "initParams", "NextListener"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

