/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.directory.DirContext;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.cluster.CatalinaCluster;
import org.apache.catalina.core.StandardContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.ObjectNameUtil;
import org.apache.geronimo.management.J2EEApplication;
import org.apache.geronimo.management.J2EEServer;
import org.apache.geronimo.management.geronimo.WebConnector;
import org.apache.geronimo.management.geronimo.WebContainer;
import org.apache.geronimo.management.geronimo.WebModule;
import org.apache.geronimo.security.jacc.RoleDesignateSource;
import org.apache.geronimo.tomcat.ManagerGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;
import org.apache.geronimo.tomcat.TomcatContainer;
import org.apache.geronimo.tomcat.TomcatContext;
import org.apache.geronimo.tomcat.ValveGBean;
import org.apache.geronimo.tomcat.cluster.CatalinaClusterGBean;
import org.apache.geronimo.tomcat.util.SecurityHolder;
import org.apache.geronimo.transaction.TrackedConnectionAssociator;
import org.apache.geronimo.transaction.context.OnlineUserTransaction;
import org.apache.geronimo.transaction.context.TransactionContextManager;
import org.apache.naming.resources.DirContextURLStreamHandler;

public class TomcatWebAppContext
implements GBeanLifecycle,
TomcatContext,
WebModule {
    private static Log log;
    protected final TomcatContainer container;
    private final ClassLoader classLoader;
    protected Context context = null;
    private String path = null;
    private String docBase = null;
    private String virtualServer = null;
    private final Realm realm;
    private final List valveChain;
    private final CatalinaCluster catalinaCluster;
    private final Manager manager;
    private final boolean crossContext;
    private final boolean disableCookies;
    private final Map componentContext;
    private final Kernel kernel;
    private final Set unshareableResources;
    private final Set applicationManagedSecurityResources;
    private final TrackedConnectionAssociator trackedConnectionAssociator;
    private final TransactionContextManager transactionContextManager;
    private final RoleDesignateSource roleDesignateSource;
    private final SecurityHolder securityHolder;
    private final J2EEServer server;
    private final J2EEApplication application;
    private final Map webServices;
    private final String objectName;
    private final String originalSpecDD;
    private final URL configurationBaseURL;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TomcatWebAppContext(ClassLoader classLoader, String objectName, String originalSpecDD, URL configurationBaseUrl, SecurityHolder securityHolder, String virtualServer, Map componentContext, Set unshareableResources, Set applicationManagedSecurityResources, OnlineUserTransaction userTransaction, TransactionContextManager transactionContextManager, TrackedConnectionAssociator trackedConnectionAssociator, TomcatContainer container, RoleDesignateSource roleDesignateSource, ObjectRetriever tomcatRealm, ValveGBean tomcatValveChain, CatalinaClusterGBean cluster, ManagerGBean manager, boolean crossContext, boolean disableCookies, Map webServices, J2EEServer server, J2EEApplication application, Kernel kernel) throws Exception {
        if (!$assertionsDisabled && classLoader == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && configurationBaseUrl == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && transactionContextManager == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && trackedConnectionAssociator == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && componentContext == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && container == null) {
            throw new AssertionError();
        }
        this.objectName = objectName;
        URI root = configurationBaseUrl.getProtocol().equalsIgnoreCase("file") ? new URI("file", configurationBaseUrl.getPath(), null) : URI.create(configurationBaseUrl.toString());
        this.setDocBase(root.getPath());
        this.container = container;
        this.originalSpecDD = originalSpecDD;
        this.virtualServer = virtualServer;
        this.securityHolder = securityHolder;
        this.componentContext = componentContext;
        this.transactionContextManager = transactionContextManager;
        this.unshareableResources = unshareableResources;
        this.applicationManagedSecurityResources = applicationManagedSecurityResources;
        this.trackedConnectionAssociator = trackedConnectionAssociator;
        this.roleDesignateSource = roleDesignateSource;
        this.server = server;
        this.application = application;
        this.configurationBaseURL = configurationBaseUrl;
        if (tomcatRealm != null) {
            this.realm = (Realm)tomcatRealm.getInternalObject();
            if (this.realm == null) {
                throw new IllegalArgumentException("tomcatRealm must be an instance of org.apache.catalina.Realm.");
            }
        } else {
            this.realm = null;
        }
        if (tomcatValveChain != null) {
            ArrayList<Valve> chain = new ArrayList<Valve>();
            for (ValveGBean valveGBean = tomcatValveChain; valveGBean != null; valveGBean = valveGBean.getNextValve()) {
                chain.add((Valve)valveGBean.getInternalObject());
            }
            this.valveChain = chain;
        } else {
            this.valveChain = null;
        }
        this.catalinaCluster = cluster != null ? (CatalinaCluster)cluster.getInternalObject() : null;
        this.manager = manager != null ? (Manager)manager.getInternalObject() : null;
        this.crossContext = crossContext;
        this.disableCookies = disableCookies;
        this.webServices = webServices;
        this.classLoader = classLoader;
        this.kernel = kernel;
        if (objectName != null) {
            ObjectName myObjectName = ObjectNameUtil.getObjectName((String)objectName);
            this.verifyObjectName(myObjectName);
        }
        if (securityHolder != null && roleDesignateSource == null) {
            throw new IllegalArgumentException("RoleDesignateSource must be supplied for a secure web app");
        }
        userTransaction.setUp(transactionContextManager, trackedConnectionAssociator);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    public URL getWARDirectory() {
        return this.configurationBaseURL;
    }

    public String getWARName() {
        try {
            return ObjectName.getInstance(this.objectName).getKeyProperty("name");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public WebContainer getContainer() {
        return this.container;
    }

    public String getServer() {
        return this.server == null ? null : this.server.getObjectName();
    }

    public String getDocBase() {
        return this.docBase;
    }

    public void setDocBase(String docBase) {
        this.docBase = docBase;
    }

    public Map getComponentContext() {
        return this.componentContext;
    }

    public String getVirtualServer() {
        return this.virtualServer;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public boolean isDisableCookies() {
        return this.disableCookies;
    }

    public TransactionContextManager getTransactionContextManager() {
        return this.transactionContextManager;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public URL getURLFor() {
        WebConnector[] connectors = (WebConnector[])this.container.getConnectors();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < connectors.length; ++i) {
            WebConnector connector = connectors[i];
            map.put(connector.getProtocol(), connector.getConnectUrl());
        }
        String urlPrefix = (String)map.get("HTTP");
        if (urlPrefix == null && (urlPrefix = (String)map.get("HTTPS")) == null) {
            urlPrefix = (String)map.get("AJP");
        }
        if (urlPrefix == null) {
            return null;
        }
        try {
            return new URL(urlPrefix + this.getContextPath());
        }
        catch (MalformedURLException e) {
            log.error((Object)"Bad URL to connect to web app", (Throwable)e);
            return null;
        }
    }

    public String getContextPath() {
        return this.path;
    }

    public void setContextPath(String path) {
        this.path = path.startsWith("/") ? path : "/" + path;
    }

    public SecurityHolder getSecurityHolder() {
        return this.securityHolder;
    }

    public Set getApplicationManagedSecurityResources() {
        return this.applicationManagedSecurityResources;
    }

    public TrackedConnectionAssociator getTrackedConnectionAssociator() {
        return this.trackedConnectionAssociator;
    }

    public Set getUnshareableResources() {
        return this.unshareableResources;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public List getValveChain() {
        return this.valveChain;
    }

    public CatalinaCluster getCluster() {
        return this.catalinaCluster;
    }

    public Manager getManager() {
        return this.manager;
    }

    public boolean isCrossContext() {
        return this.crossContext;
    }

    public Map getWebServices() {
        return this.webServices;
    }

    public String[] getServlets() {
        String[] result = null;
        if (this.context != null && this.context instanceof StandardContext) {
            result = ((StandardContext)this.context).getServlets();
        }
        return result;
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"WebModule".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("WebModule object name j2eeType property must be 'WebModule'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("WebModule object must contain a name property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEServer")) {
            throw new InvalidObjectNameException("WebModule object name must contain a J2EEServer property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEApplication")) {
            throw new InvalidObjectNameException("WebModule object name must contain a J2EEApplication property", objectName);
        }
        if (keyPropertyList.size() != 4) {
            throw new InvalidObjectNameException("WebModule object name can only have j2eeType, name, J2EEApplication, and J2EEServer properties", objectName);
        }
    }

    public String[] getJavaVMs() {
        return this.server == null ? new String[]{} : this.server.getJavaVMs();
    }

    public String getDeploymentDescriptor() {
        return this.originalSpecDD;
    }

    public void doStart() throws Exception {
        this.container.addContext(this);
        DirContext resources = this.context.getResources();
        DirContextURLStreamHandler.bind((ClassLoader)this.classLoader, (DirContext)resources);
        log.debug((Object)("TomcatWebAppContext started for " + this.path));
    }

    public void doStop() throws Exception {
        this.container.removeContext(this);
        DirContextURLStreamHandler.unbind((ClassLoader)this.classLoader);
        log.debug((Object)"TomcatWebAppContext stopped");
    }

    public void doFail() {
        this.container.removeContext(this);
        log.warn((Object)"TomcatWebAppContext failed");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !TomcatWebAppContext.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)TomcatWebAppContext.class);
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((String)"Tomcat WebApplication Context", (Class)TomcatWebAppContext.class, (String)"WebModule");
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.addAttribute("objectName", String.class, false);
        infoBuilder.addAttribute("deploymentDescriptor", String.class, true);
        infoBuilder.addAttribute("configurationBaseUrl", URL.class, true);
        infoBuilder.addAttribute("contextPath", String.class, true);
        infoBuilder.addAttribute("securityHolder", SecurityHolder.class, true);
        infoBuilder.addAttribute("virtualServer", String.class, true);
        infoBuilder.addAttribute("componentContext", Map.class, true);
        infoBuilder.addAttribute("unshareableResources", Set.class, true);
        infoBuilder.addAttribute("applicationManagedSecurityResources", Set.class, true);
        infoBuilder.addAttribute("userTransaction", OnlineUserTransaction.class, true);
        infoBuilder.addReference("TransactionContextManager", TransactionContextManager.class, "TransactionContextManager");
        infoBuilder.addReference("TrackedConnectionAssociator", TrackedConnectionAssociator.class, "JCAConnectionTracker");
        infoBuilder.addReference("Container", TomcatContainer.class, "GBean");
        infoBuilder.addReference("RoleDesignateSource", RoleDesignateSource.class, "JACCManager");
        infoBuilder.addReference("TomcatRealm", ObjectRetriever.class);
        infoBuilder.addReference("TomcatValveChain", ValveGBean.class);
        infoBuilder.addReference("Cluster", CatalinaClusterGBean.class, "Cluster");
        infoBuilder.addReference("Manager", ManagerGBean.class);
        infoBuilder.addAttribute("crossContext", Boolean.TYPE, true);
        infoBuilder.addAttribute("disableCookies", Boolean.TYPE, true);
        infoBuilder.addAttribute("webServices", Map.class, true);
        infoBuilder.addReference("J2EEServer", J2EEServer.class);
        infoBuilder.addReference("J2EEApplication", J2EEApplication.class);
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.addInterface(WebModule.class);
        infoBuilder.setConstructor(new String[]{"classLoader", "objectName", "deploymentDescriptor", "configurationBaseUrl", "securityHolder", "virtualServer", "componentContext", "unshareableResources", "applicationManagedSecurityResources", "userTransaction", "TransactionContextManager", "TrackedConnectionAssociator", "Container", "RoleDesignateSource", "TomcatRealm", "TomcatValveChain", "Cluster", "Manager", "crossContext", "disableCookies", "webServices", "J2EEServer", "J2EEApplication", "kernel"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

