/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.cluster.CatalinaCluster;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.naming.enc.EnterpriseNamingContext;
import org.apache.geronimo.naming.reference.ClassLoaderAwareReference;
import org.apache.geronimo.naming.reference.KernelAwareReference;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.IdentificationPrincipal;
import org.apache.geronimo.security.SubjectId;
import org.apache.geronimo.security.deploy.DefaultPrincipal;
import org.apache.geronimo.security.util.ConfigurationUtil;
import org.apache.geronimo.tomcat.TomcatContext;
import org.apache.geronimo.tomcat.TomcatWebAppContext;
import org.apache.geronimo.tomcat.interceptor.BeforeAfter;
import org.apache.geronimo.tomcat.interceptor.ComponentContextBeforeAfter;
import org.apache.geronimo.tomcat.interceptor.InstanceContextBeforeAfter;
import org.apache.geronimo.tomcat.interceptor.PolicyContextBeforeAfter;
import org.apache.geronimo.tomcat.interceptor.TransactionContextBeforeAfter;
import org.apache.geronimo.tomcat.util.SecurityHolder;
import org.apache.geronimo.tomcat.valve.DefaultSubjectValve;
import org.apache.geronimo.tomcat.valve.GeronimoBeforeAfterValve;
import org.apache.geronimo.transaction.context.TransactionContextManager;
import org.apache.geronimo.webservices.POJOWebServiceServlet;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.geronimo.webservices.WebServiceContainerInvoker;

public class GeronimoStandardContext
extends StandardContext {
    private static final Log log = LogFactory.getLog((Class)GeronimoStandardContext.class);
    private static final long serialVersionUID = 3834587716552831032L;
    private Subject defaultSubject = null;
    private Map webServiceMap = null;
    private boolean pipelineInitialized;
    private BeforeAfter beforeAfter = null;
    private int contextCount = 0;

    public void setContextProperties(TomcatContext ctx) throws DeploymentException {
        Manager manager;
        CatalinaCluster cluster;
        SecurityHolder securityHolder;
        TransactionContextManager transactionContextManager;
        if (ctx instanceof TomcatWebAppContext) {
            TomcatWebAppContext tctx = (TomcatWebAppContext)ctx;
            this.setJavaVMs(tctx.getJavaVMs());
            this.setServer(tctx.getServer());
        }
        Context enc = null;
        Map componentContext = ctx.getComponentContext();
        try {
            if (componentContext != null) {
                Iterator iterator = componentContext.values().iterator();
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    if (value instanceof KernelAwareReference) {
                        ((KernelAwareReference)value).setKernel(ctx.getKernel());
                    }
                    if (!(value instanceof ClassLoaderAwareReference)) continue;
                    ((ClassLoaderAwareReference)value).setClassLoader(ctx.getClassLoader());
                }
                enc = EnterpriseNamingContext.createEnterpriseNamingContext((Map)componentContext);
            }
        }
        catch (NamingException ne) {
            log.error((Object)ne);
        }
        int index = 0;
        BeforeAfter interceptor = new InstanceContextBeforeAfter(null, index++, ctx.getUnshareableResources(), ctx.getApplicationManagedSecurityResources(), ctx.getTrackedConnectionAssociator());
        if (enc != null) {
            interceptor = new ComponentContextBeforeAfter(interceptor, index++, enc);
        }
        if ((transactionContextManager = ctx.getTransactionContextManager()) != null) {
            interceptor = new TransactionContextBeforeAfter(interceptor, index++, transactionContextManager);
        }
        if ((securityHolder = ctx.getSecurityHolder()) != null && securityHolder.getPolicyContextID() != null) {
            PolicyContext.setContextID((String)securityHolder.getPolicyContextID());
            DefaultPrincipal defaultPrincipal = securityHolder.getDefaultPrincipal();
            if (defaultPrincipal != null) {
                this.defaultSubject = ConfigurationUtil.generateDefaultSubject((DefaultPrincipal)defaultPrincipal, (ClassLoader)ctx.getClassLoader());
                ContextManager.registerSubject((Subject)this.defaultSubject);
                SubjectId id = ContextManager.getSubjectId((Subject)this.defaultSubject);
                this.defaultSubject.getPrincipals().add((Principal)new IdentificationPrincipal(id));
            }
            interceptor = new PolicyContextBeforeAfter(interceptor, index++, securityHolder.getPolicyContextID());
        }
        GeronimoBeforeAfterValve geronimoBAValve = new GeronimoBeforeAfterValve(interceptor, index);
        this.addValve((Valve)geronimoBAValve);
        this.beforeAfter = interceptor;
        this.contextCount = index;
        this.addValve((Valve)new SystemMethodValve());
        List valveChain = ctx.getValveChain();
        if (valveChain != null) {
            Iterator iterator = valveChain.iterator();
            while (iterator.hasNext()) {
                Valve valve = (Valve)iterator.next();
                this.addValve(valve);
            }
        }
        if ((cluster = ctx.getCluster()) != null) {
            this.setCluster((Cluster)cluster);
        }
        if ((manager = ctx.getManager()) != null) {
            this.setManager(manager);
        }
        this.pipelineInitialized = true;
        this.webServiceMap = ctx.getWebServices();
        this.setCrossContext(ctx.isCrossContext());
        this.setCookies(!ctx.isDisableCookies());
        this.addInstanceListener("org.apache.geronimo.tomcat.listener.DispatchListener");
    }

    public synchronized void start() throws LifecycleException {
        if (this.pipelineInitialized) {
            try {
                Valve valve = this.getFirst();
                valve.invoke(null, null);
                DefaultSubjectValve defaultSubjectValve = new DefaultSubjectValve(this.defaultSubject);
                this.addValve((Valve)defaultSubjectValve);
            }
            catch (IOException e) {
                if (e.getCause() instanceof LifecycleException) {
                    throw (LifecycleException)e.getCause();
                }
                throw new LifecycleException((Throwable)e);
            }
            catch (ServletException e) {
                throw new LifecycleException((Throwable)e);
            }
        } else {
            super.start();
        }
    }

    public synchronized void stop() throws LifecycleException {
        if (this.defaultSubject != null) {
            ContextManager.unregisterSubject((Subject)this.defaultSubject);
        }
        super.stop();
    }

    public void addChild(Container child) {
        Wrapper wrapper = (Wrapper)child;
        String servletClassName = wrapper.getServletClass();
        if (servletClassName == null) {
            super.addChild(child);
            return;
        }
        ClassLoader cl = this.getParentClassLoader();
        try {
            WebServiceContainer webServiceContainer;
            Class<?> baseServletClass = cl.loadClass(Servlet.class.getName());
            Class<?> servletClass = cl.loadClass(servletClassName);
            if (!baseServletClass.isAssignableFrom(servletClass) && this.webServiceMap != null && (webServiceContainer = (WebServiceContainer)this.webServiceMap.get(wrapper.getName())) != null) {
                wrapper.setServletClass("org.apache.geronimo.webservices.POJOWebServiceServlet");
                String webServicecontainerID = wrapper.getName() + WebServiceContainerInvoker.WEBSERVICE_CONTAINER + webServiceContainer.hashCode();
                this.getServletContext().setAttribute(webServicecontainerID, (Object)webServiceContainer);
                wrapper.addInitParameter(WebServiceContainerInvoker.WEBSERVICE_CONTAINER, webServicecontainerID);
                String pojoClassID = wrapper.getName() + POJOWebServiceServlet.POJO_CLASS + servletClass.hashCode();
                this.getServletContext().setAttribute(pojoClassID, servletClass);
                wrapper.addInitParameter(POJOWebServiceServlet.POJO_CLASS, pojoClassID);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        super.addChild(child);
    }

    public synchronized void setLoader(final Loader delegate) {
        Loader loader = new Loader(){

            public void backgroundProcess() {
                delegate.backgroundProcess();
            }

            public ClassLoader getClassLoader() {
                return GeronimoStandardContext.this.parentClassLoader;
            }

            public Container getContainer() {
                return delegate.getContainer();
            }

            public void setContainer(Container container) {
                delegate.setContainer(container);
            }

            public boolean getDelegate() {
                return delegate.getDelegate();
            }

            public void setDelegate(boolean delegateBoolean) {
                delegate.setDelegate(delegateBoolean);
            }

            public String getInfo() {
                return delegate.getInfo();
            }

            public boolean getReloadable() {
                return false;
            }

            public void setReloadable(boolean reloadable) {
                if (reloadable) {
                    throw new UnsupportedOperationException("Reloadable context is not supported.");
                }
            }

            public void addPropertyChangeListener(PropertyChangeListener listener) {
                delegate.addPropertyChangeListener(listener);
            }

            public void addRepository(String repository) {
                delegate.addRepository(repository);
            }

            public String[] findRepositories() {
                return delegate.findRepositories();
            }

            public boolean modified() {
                return delegate.modified();
            }

            public void removePropertyChangeListener(PropertyChangeListener listener) {
                delegate.removePropertyChangeListener(listener);
            }
        };
        super.setLoader(loader);
    }

    public BeforeAfter getBeforeAfter() {
        return this.beforeAfter;
    }

    public int getContextCount() {
        return this.contextCount;
    }

    private class SystemMethodValve
    extends ValveBase {
        private SystemMethodValve() {
        }

        public void invoke(Request request, Response response) throws IOException, ServletException {
            if (request == null && response == null) {
                try {
                    GeronimoStandardContext.super.start();
                }
                catch (LifecycleException e) {
                    throw (IOException)new IOException("wrapping lifecycle exception").initCause(e);
                }
            } else {
                this.getNext().invoke(request, response);
            }
        }
    }
}

