/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.gbean.ReferenceCollectionEvent;
import org.apache.geronimo.gbean.ReferenceCollectionListener;
import org.apache.geronimo.tomcat.BaseGBean;
import org.apache.geronimo.tomcat.HostGBean;
import org.apache.geronimo.tomcat.ManagerGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;
import org.apache.geronimo.tomcat.ValveGBean;
import org.apache.geronimo.tomcat.cluster.CatalinaClusterGBean;

public class EngineGBean
extends BaseGBean
implements GBeanLifecycle,
ObjectRetriever {
    private static final Log log = LogFactory.getLog((Class)EngineGBean.class);
    private static final String NAME = "name";
    private static final String DEFAULTHOST = "defaultHost";
    private final Engine engine;
    public static final GBeanInfo GBEAN_INFO;

    public EngineGBean(String className, Map initParams, HostGBean defaultHost, Collection hosts, ObjectRetriever realmGBean, ValveGBean tomcatValveChain, CatalinaClusterGBean clusterGBean, ManagerGBean manager) throws Exception {
        if (className == null) {
            className = "org.apache.geronimo.tomcat.TomcatEngine";
        }
        if (initParams == null) {
            throw new IllegalArgumentException("Must have 'name' value in initParams.");
        }
        if (defaultHost == null) {
            throw new IllegalArgumentException("Must have a 'defaultHost' attribute.");
        }
        if (!initParams.containsKey(NAME)) {
            throw new IllegalArgumentException("Must have a 'name' value initParams.");
        }
        if (initParams.containsKey(DEFAULTHOST)) {
            log.warn((Object)"The defaultHost initParams value is no longer used and will be ignored.");
            initParams.remove(DEFAULTHOST);
        }
        this.engine = (Engine)Class.forName(className).newInstance();
        this.setParameters(this.engine, initParams);
        if (realmGBean != null) {
            this.engine.setRealm((Realm)realmGBean.getInternalObject());
        }
        final String defaultHostName = ((Host)defaultHost.getInternalObject()).getName();
        this.engine.setDefaultHost(defaultHostName);
        this.addHost(defaultHost);
        if (manager != null) {
            this.engine.setManager((Manager)manager.getInternalObject());
        }
        if (this.engine instanceof StandardEngine && tomcatValveChain != null) {
            for (ValveGBean valveGBean = tomcatValveChain; valveGBean != null; valveGBean = valveGBean.getNextValve()) {
                ((StandardEngine)this.engine).addValve((Valve)valveGBean.getInternalObject());
            }
        }
        if (hosts instanceof ReferenceCollection) {
            ReferenceCollection refs = (ReferenceCollection)hosts;
            refs.addReferenceCollectionListener(new ReferenceCollectionListener(){

                public void memberAdded(ReferenceCollectionEvent event) {
                    Object o = event.getMember();
                    ObjectRetriever objectRetriever = (ObjectRetriever)o;
                    String hostName = ((Host)objectRetriever.getInternalObject()).getName();
                    if (!hostName.equals(defaultHostName)) {
                        EngineGBean.this.addHost(objectRetriever);
                    }
                }

                public void memberRemoved(ReferenceCollectionEvent event) {
                    Object o = event.getMember();
                    ObjectRetriever objectRetriever = (ObjectRetriever)o;
                    String hostName = ((Host)objectRetriever.getInternalObject()).getName();
                    if (!hostName.equals(defaultHostName)) {
                        EngineGBean.this.removeHost(objectRetriever);
                    }
                }
            });
            Iterator iterator = refs.iterator();
            while (iterator.hasNext()) {
                ObjectRetriever objRetriever = (ObjectRetriever)iterator.next();
                String hostName = ((Host)objRetriever.getInternalObject()).getName();
                if (hostName.equals(defaultHostName)) continue;
                this.addHost(objRetriever);
            }
        }
        if (clusterGBean != null) {
            this.engine.setCluster((Cluster)clusterGBean.getInternalObject());
        }
    }

    private void removeHost(ObjectRetriever objRetriever) {
        Host host = (Host)objRetriever.getInternalObject();
        this.engine.removeChild((Container)host);
    }

    private void addHost(ObjectRetriever objRetriever) {
        Host host = (Host)objRetriever.getInternalObject();
        if (host.getRealm() == null) {
            host.setRealm(this.engine.getRealm());
        }
        this.engine.addChild((Container)host);
    }

    public Object getInternalObject() {
        return this.engine;
    }

    public void doFail() {
        log.warn((Object)"Failed");
    }

    public void doStart() throws Exception {
        log.debug((Object)"Started");
    }

    public void doStop() throws Exception {
        log.debug((Object)"Stopped");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"TomcatEngine", (Class)EngineGBean.class);
        infoFactory.addAttribute("className", String.class, true);
        infoFactory.addAttribute("initParams", Map.class, true);
        infoFactory.addReference("DefaultHost", HostGBean.class, "Host");
        infoFactory.addReference("Hosts", ObjectRetriever.class, "Host");
        infoFactory.addReference("RealmGBean", ObjectRetriever.class, "GBean");
        infoFactory.addReference("TomcatValveChain", ValveGBean.class, "TomcatValve");
        infoFactory.addReference("CatalinaCluster", CatalinaClusterGBean.class, "Cluster");
        infoFactory.addReference("Manager", ManagerGBean.class, "Manager");
        infoFactory.addOperation("getInternalObject");
        infoFactory.setConstructor(new String[]{"className", "initParams", "DefaultHost", "Hosts", "RealmGBean", "TomcatValveChain", "CatalinaCluster", "Manager"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

