/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.listener;

import java.util.Stack;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.core.StandardWrapper;
import org.apache.geronimo.tomcat.GeronimoStandardContext;
import org.apache.geronimo.tomcat.interceptor.BeforeAfter;
import org.apache.geronimo.tomcat.realm.TomcatGeronimoRealm;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.mapper.Mapper;
import org.apache.tomcat.util.http.mapper.MappingData;

public class DispatchListener
implements InstanceListener {
    private static ThreadLocal currentContext = new ThreadLocal(){

        protected Object initialValue() {
            return new Stack();
        }
    };

    public void instanceEvent(InstanceEvent event) {
        Container parent;
        if (event.getType().equals("beforeDispatch") && (parent = event.getWrapper().getParent()) instanceof GeronimoStandardContext) {
            this.beforeDispatch((GeronimoStandardContext)parent, event.getRequest(), event.getResponse());
        }
        if (event.getType().equals("afterDispatch") && (parent = event.getWrapper().getParent()) instanceof GeronimoStandardContext) {
            this.afterDispatch((GeronimoStandardContext)parent, event.getRequest(), event.getResponse());
        }
    }

    private void beforeDispatch(GeronimoStandardContext webContext, ServletRequest request, ServletResponse response) {
        BeforeAfter beforeAfter = webContext.getBeforeAfter();
        if (beforeAfter != null) {
            Stack stack = (Stack)currentContext.get();
            Object[] context = new Object[webContext.getContextCount() + 1];
            String wrapperName = this.getWrapperName(request, webContext);
            context[webContext.getContextCount()] = TomcatGeronimoRealm.setRequestWrapperName(wrapperName);
            beforeAfter.before(context, request, response);
            stack.push(context);
        }
    }

    private void afterDispatch(GeronimoStandardContext webContext, ServletRequest request, ServletResponse response) {
        BeforeAfter beforeAfter = webContext.getBeforeAfter();
        if (beforeAfter != null) {
            Stack stack = (Stack)currentContext.get();
            Object[] context = (Object[])stack.pop();
            beforeAfter.after(context, request, response);
            TomcatGeronimoRealm.setRequestWrapperName((String)context[webContext.getContextCount()]);
        }
    }

    private String getWrapperName(ServletRequest request, GeronimoStandardContext webContext) {
        MappingData mappingData = new MappingData();
        Mapper mapper = webContext.getMapper();
        MessageBytes mb = MessageBytes.newInstance();
        String dispatchPath = (String)request.getAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH");
        mb.setString(webContext.getName() + dispatchPath);
        try {
            mapper.map(mb, mappingData);
            StandardWrapper wrapper = (StandardWrapper)mappingData.wrapper;
            return wrapper.getName();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

