/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.valve;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.geronimo.transaction.context.TransactionContext;
import org.apache.geronimo.transaction.context.TransactionContextManager;

public class TransactionContextValve
extends ValveBase {
    private final TransactionContextManager transactionContextManager;

    public TransactionContextValve(TransactionContextManager transactionContextManager) {
        this.transactionContextManager = transactionContextManager;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        TransactionContext oldTransactionContext = this.transactionContextManager.getContext();
        TransactionContext newTransactionContext = null;
        if (oldTransactionContext == null || !oldTransactionContext.isInheritable()) {
            newTransactionContext = this.transactionContextManager.newUnspecifiedTransactionContext();
        }
        this.getNext().invoke(request, response);
        try {
            if (newTransactionContext != null) {
                if (newTransactionContext != this.transactionContextManager.getContext()) {
                    this.transactionContextManager.getContext().rollback();
                    newTransactionContext.rollback();
                    throw new RuntimeException("WRONG EXCEPTION! returned from servlet call with wrong tx context");
                }
                newTransactionContext.commit();
            } else if (oldTransactionContext != this.transactionContextManager.getContext()) {
                if (this.transactionContextManager.getContext() != null) {
                    this.transactionContextManager.getContext().rollback();
                }
                throw new RuntimeException("WRONG EXCEPTION! returned from servlet call with wrong tx context");
            }
        }
        catch (SystemException e) {
            throw new RuntimeException("WRONG EXCEPTION!", e);
        }
        catch (HeuristicMixedException e) {
            throw new RuntimeException("WRONG EXCEPTION!", e);
        }
        catch (HeuristicRollbackException e) {
            throw new RuntimeException("WRONG EXCEPTION!", e);
        }
        catch (RollbackException e) {
            throw new RuntimeException("WRONG EXCEPTION!", e);
        }
        finally {
            this.transactionContextManager.setContext(oldTransactionContext);
        }
    }
}

