/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.valve;

import java.io.IOException;
import java.util.Set;
import javax.resource.ResourceException;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.geronimo.transaction.DefaultInstanceContext;
import org.apache.geronimo.transaction.InstanceContext;
import org.apache.geronimo.transaction.TrackedConnectionAssociator;

public class InstanceContextValve
extends ValveBase {
    private final Set unshareableResources;
    private final Set applicationManagedSecurityResources;
    private final TrackedConnectionAssociator trackedConnectionAssociator;

    public InstanceContextValve(Set unshareableResources, Set applicationManagedSecurityResources, TrackedConnectionAssociator trackedConnectionAssociator) {
        this.unshareableResources = unshareableResources;
        this.applicationManagedSecurityResources = applicationManagedSecurityResources;
        this.trackedConnectionAssociator = trackedConnectionAssociator;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        try {
            InstanceContext oldContext = this.trackedConnectionAssociator.enter((InstanceContext)new DefaultInstanceContext(this.unshareableResources, this.applicationManagedSecurityResources));
            this.getNext().invoke(request, response);
            this.trackedConnectionAssociator.exit(oldContext);
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
    }
}

