/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import [Ljava.net.URI;;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.cluster.CatalinaCluster;
import org.apache.catalina.core.StandardContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.jmx.JMXUtil;
import org.apache.geronimo.management.J2EEApplication;
import org.apache.geronimo.management.J2EEServer;
import org.apache.geronimo.management.geronimo.WebModule;
import org.apache.geronimo.security.jacc.RoleDesignateSource;
import org.apache.geronimo.tomcat.ObjectRetriever;
import org.apache.geronimo.tomcat.TomcatClassLoader;
import org.apache.geronimo.tomcat.TomcatContainer;
import org.apache.geronimo.tomcat.TomcatContext;
import org.apache.geronimo.tomcat.ValveGBean;
import org.apache.geronimo.tomcat.cluster.CatalinaClusterGBean;
import org.apache.geronimo.tomcat.cluster.WADIGBean;
import org.apache.geronimo.tomcat.util.SecurityHolder;
import org.apache.geronimo.transaction.TrackedConnectionAssociator;
import org.apache.geronimo.transaction.context.OnlineUserTransaction;
import org.apache.geronimo.transaction.context.TransactionContextManager;

public class TomcatWebAppContext
implements GBeanLifecycle,
TomcatContext,
WebModule {
    private static Log log;
    protected final TomcatContainer container;
    private final ClassLoader webClassLoader;
    protected Context context = null;
    private final URI webAppRoot;
    private String path = null;
    private String docBase = null;
    private String virtualServer = null;
    private final Realm realm;
    private final List valveChain;
    private final CatalinaCluster catalinaCluster;
    private final Manager manager;
    private final boolean crossContext;
    private final Map componentContext;
    private final Kernel kernel;
    private final Set unshareableResources;
    private final Set applicationManagedSecurityResources;
    private final TrackedConnectionAssociator trackedConnectionAssociator;
    private final TransactionContextManager transactionContextManager;
    private final RoleDesignateSource roleDesignateSource;
    private final SecurityHolder securityHolder;
    private final J2EEServer server;
    private final J2EEApplication application;
    private final Map webServices;
    private final String objectName;
    private final String originalSpecDD;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TomcatWebAppContext(ClassLoader classLoader, String objectName, String originalSpecDD, URI relativeWebAppRoot, URI[] webClassPath, boolean contextPriorityClassLoader, URL configurationBaseUrl, SecurityHolder securityHolder, String virtualServer, Map componentContext, Set unshareableResources, Set applicationManagedSecurityResources, OnlineUserTransaction userTransaction, TransactionContextManager transactionContextManager, TrackedConnectionAssociator trackedConnectionAssociator, TomcatContainer container, RoleDesignateSource roleDesignateSource, ObjectRetriever tomcatRealm, ValveGBean tomcatValveChain, CatalinaClusterGBean cluster, WADIGBean manager, boolean crossContext, Map webServices, J2EEServer server, J2EEApplication application, Kernel kernel) throws Exception {
        if (!$assertionsDisabled && classLoader == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && relativeWebAppRoot == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && webClassPath == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && configurationBaseUrl == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && transactionContextManager == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && trackedConnectionAssociator == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && componentContext == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && container == null) {
            throw new AssertionError();
        }
        this.objectName = objectName;
        URI root = null;
        root = configurationBaseUrl.getProtocol().equalsIgnoreCase("file") ? new URI("file", configurationBaseUrl.getPath(), null) : URI.create(configurationBaseUrl.toString());
        this.webAppRoot = root.resolve(relativeWebAppRoot);
        this.container = container;
        this.originalSpecDD = originalSpecDD;
        this.setDocBase(this.webAppRoot.getPath());
        this.virtualServer = virtualServer;
        this.securityHolder = securityHolder;
        this.componentContext = componentContext;
        this.transactionContextManager = transactionContextManager;
        this.unshareableResources = unshareableResources;
        this.applicationManagedSecurityResources = applicationManagedSecurityResources;
        this.trackedConnectionAssociator = trackedConnectionAssociator;
        this.roleDesignateSource = roleDesignateSource;
        this.server = server;
        this.application = application;
        if (tomcatRealm != null) {
            this.realm = (Realm)tomcatRealm.getInternalObject();
            if (!(this.realm instanceof Realm)) {
                throw new IllegalArgumentException("tomcatRealm must be an instance of org.apache.catalina.Realm.");
            }
        } else {
            this.realm = null;
        }
        if (tomcatValveChain != null) {
            ArrayList<Valve> chain = new ArrayList<Valve>();
            for (ValveGBean valveGBean = tomcatValveChain; valveGBean != null; valveGBean = valveGBean.getNextValve()) {
                chain.add((Valve)valveGBean.getInternalObject());
            }
            this.valveChain = chain;
        } else {
            this.valveChain = null;
        }
        this.catalinaCluster = cluster != null ? (CatalinaCluster)cluster.getInternalObject() : null;
        this.manager = manager != null ? (Manager)manager.getInternalObject() : null;
        this.crossContext = crossContext;
        this.webServices = webServices;
        URL webAppRootURL = this.webAppRoot.toURL();
        URL[] urls = new URL[webClassPath.length];
        for (int i = 0; i < webClassPath.length; ++i) {
            URI classPathEntry = webClassPath[i];
            classPathEntry = root.resolve(classPathEntry);
            urls[i] = classPathEntry.toURL();
        }
        this.webClassLoader = new TomcatClassLoader(urls, webAppRootURL, classLoader, contextPriorityClassLoader);
        this.kernel = kernel;
        ObjectName myObjectName = JMXUtil.getObjectName((String)objectName);
        this.verifyObjectName(myObjectName);
        if (securityHolder != null && roleDesignateSource == null) {
            throw new IllegalArgumentException("RoleDesignateSource must be supplied for a secure web app");
        }
        userTransaction.setUp(transactionContextManager, trackedConnectionAssociator);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    public String getContainerName() {
        return this.container.getObjectName();
    }

    public String getServer() {
        return this.server.getObjectName();
    }

    public String getDocBase() {
        return this.docBase;
    }

    public void setDocBase(String docBase) {
        this.docBase = docBase;
    }

    public Map getComponentContext() {
        return this.componentContext;
    }

    public String getVirtualServer() {
        return this.virtualServer;
    }

    public ClassLoader getWebClassLoader() {
        return this.webClassLoader;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public TransactionContextManager getTransactionContextManager() {
        return this.transactionContextManager;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public String getContextPath() {
        return this.path;
    }

    public void setContextPath(String path) {
        this.path = path.startsWith("/") ? path : "/" + path;
    }

    public SecurityHolder getSecurityHolder() {
        return this.securityHolder;
    }

    public Set getApplicationManagedSecurityResources() {
        return this.applicationManagedSecurityResources;
    }

    public TrackedConnectionAssociator getTrackedConnectionAssociator() {
        return this.trackedConnectionAssociator;
    }

    public Set getUnshareableResources() {
        return this.unshareableResources;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public List getValveChain() {
        return this.valveChain;
    }

    public CatalinaCluster getCluster() {
        return this.catalinaCluster;
    }

    public Manager getManager() {
        return this.manager;
    }

    public boolean isCrossContext() {
        return this.crossContext;
    }

    public Map getWebServices() {
        return this.webServices;
    }

    public String[] getServlets() {
        String[] result = null;
        if (this.context != null && this.context instanceof StandardContext) {
            result = ((StandardContext)this.context).getServlets();
        }
        return result;
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"WebModule".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("WebModule object name j2eeType property must be 'WebModule'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("WebModule object must contain a name property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEServer")) {
            throw new InvalidObjectNameException("WebModule object name must contain a J2EEServer property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEApplication")) {
            throw new InvalidObjectNameException("WebModule object name must contain a J2EEApplication property", objectName);
        }
        if (keyPropertyList.size() != 4) {
            throw new InvalidObjectNameException("WebModule object name can only have j2eeType, name, J2EEApplication, and J2EEServer properties", objectName);
        }
    }

    public String[] getJavaVMs() {
        return this.server.getJavaVMs();
    }

    public String getDeploymentDescriptor() {
        return this.originalSpecDD;
    }

    public void doStart() throws Exception {
        this.container.addContext(this);
        log.debug((Object)("TomcatWebAppContext started for " + this.path));
    }

    public void doStop() throws Exception {
        this.container.removeContext(this);
        LogFactory.release((ClassLoader)this.webClassLoader);
        log.debug((Object)"TomcatWebAppContext stopped");
    }

    public void doFail() {
        this.container.removeContext(this);
        LogFactory.release((ClassLoader)this.webClassLoader);
        log.warn((Object)"TomcatWebAppContext failed");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !TomcatWebAppContext.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)TomcatWebAppContext.class);
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((String)"Tomcat WebApplication Context", (Class)TomcatWebAppContext.class, (String)"WebModule");
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.addAttribute("objectName", String.class, false);
        infoBuilder.addAttribute("deploymentDescriptor", String.class, true);
        infoBuilder.addAttribute("webAppRoot", URI.class, true);
        infoBuilder.addAttribute("webClassPath", URI;.class, true);
        infoBuilder.addAttribute("contextPriorityClassLoader", Boolean.TYPE, true);
        infoBuilder.addAttribute("configurationBaseUrl", URL.class, true);
        infoBuilder.addAttribute("contextPath", String.class, true);
        infoBuilder.addAttribute("securityHolder", SecurityHolder.class, true);
        infoBuilder.addAttribute("virtualServer", String.class, true);
        infoBuilder.addAttribute("componentContext", Map.class, true);
        infoBuilder.addAttribute("unshareableResources", Set.class, true);
        infoBuilder.addAttribute("applicationManagedSecurityResources", Set.class, true);
        infoBuilder.addAttribute("userTransaction", OnlineUserTransaction.class, true);
        infoBuilder.addReference("TransactionContextManager", TransactionContextManager.class, "TransactionContextManager");
        infoBuilder.addReference("TrackedConnectionAssociator", TrackedConnectionAssociator.class, "JCAConnectionTracker");
        infoBuilder.addReference("Container", TomcatContainer.class, "GBean");
        infoBuilder.addReference("RoleDesignateSource", RoleDesignateSource.class, "JACCManager");
        infoBuilder.addReference("TomcatRealm", ObjectRetriever.class);
        infoBuilder.addReference("TomcatValveChain", ValveGBean.class);
        infoBuilder.addReference("Cluster", CatalinaClusterGBean.class, "Cluster");
        infoBuilder.addReference("Manager", WADIGBean.class);
        infoBuilder.addAttribute("crossContext", Boolean.TYPE, true);
        infoBuilder.addAttribute("webServices", Map.class, true);
        infoBuilder.addReference("J2EEServer", J2EEServer.class);
        infoBuilder.addReference("J2EEApplication", J2EEApplication.class);
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.addInterface(WebModule.class);
        infoBuilder.setConstructor(new String[]{"classLoader", "objectName", "deploymentDescriptor", "webAppRoot", "webClassPath", "contextPriorityClassLoader", "configurationBaseUrl", "securityHolder", "virtualServer", "componentContext", "unshareableResources", "applicationManagedSecurityResources", "userTransaction", "TransactionContextManager", "TrackedConnectionAssociator", "Container", "RoleDesignateSource", "TomcatRealm", "TomcatValveChain", "Cluster", "Manager", "crossContext", "webServices", "J2EEServer", "J2EEApplication", "kernel"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

