/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.cluster.CatalinaCluster;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.kernel.StoredObject;
import org.apache.geronimo.naming.enc.EnterpriseNamingContext;
import org.apache.geronimo.naming.reference.ClassLoaderAwareReference;
import org.apache.geronimo.naming.reference.KernelAwareReference;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.IdentificationPrincipal;
import org.apache.geronimo.security.SubjectId;
import org.apache.geronimo.security.deploy.DefaultPrincipal;
import org.apache.geronimo.security.util.ConfigurationUtil;
import org.apache.geronimo.tomcat.TomcatContext;
import org.apache.geronimo.tomcat.util.SecurityHolder;
import org.apache.geronimo.tomcat.valve.ComponentContextValve;
import org.apache.geronimo.tomcat.valve.DefaultSubjectValve;
import org.apache.geronimo.tomcat.valve.InstanceContextValve;
import org.apache.geronimo.tomcat.valve.PolicyContextValve;
import org.apache.geronimo.tomcat.valve.TransactionContextValve;
import org.apache.geronimo.transaction.context.TransactionContextManager;
import org.apache.geronimo.webservices.POJOWebServiceServlet;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.geronimo.webservices.WebServiceContainerInvoker;

public class GeronimoStandardContext
extends StandardContext {
    private static final Log log = LogFactory.getLog((Class)GeronimoStandardContext.class);
    private static final long serialVersionUID = 3834587716552831032L;
    private Subject defaultSubject = null;
    private Map webServiceMap = null;
    private boolean pipelineInitialized;

    public void setContextProperties(TomcatContext ctx) throws DeploymentException {
        Manager manager;
        CatalinaCluster cluster;
        SecurityHolder securityHolder;
        TransactionContextManager transactionContextManager;
        Context enc = null;
        Map componentContext = ctx.getComponentContext();
        try {
            if (componentContext != null) {
                Iterator iterator = componentContext.values().iterator();
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    if (value instanceof KernelAwareReference) {
                        ((KernelAwareReference)value).setKernel(ctx.getKernel());
                    }
                    if (!(value instanceof ClassLoaderAwareReference)) continue;
                    ((ClassLoaderAwareReference)value).setClassLoader(ctx.getWebClassLoader());
                }
                enc = EnterpriseNamingContext.createEnterpriseNamingContext((Map)componentContext);
            }
        }
        catch (NamingException ne) {
            log.error((Object)ne);
        }
        InstanceContextValve instanceContextValve = new InstanceContextValve(ctx.getUnshareableResources(), ctx.getApplicationManagedSecurityResources(), ctx.getTrackedConnectionAssociator());
        this.addValve((Valve)instanceContextValve);
        if (enc != null) {
            ComponentContextValve contextValve = new ComponentContextValve(enc);
            this.addValve((Valve)contextValve);
        }
        if ((transactionContextManager = ctx.getTransactionContextManager()) != null) {
            TransactionContextValve transactionValve = new TransactionContextValve(transactionContextManager);
            this.addValve((Valve)transactionValve);
        }
        if ((securityHolder = ctx.getSecurityHolder()) != null && securityHolder.getPolicyContextID() != null) {
            PolicyContext.setContextID((String)securityHolder.getPolicyContextID());
            DefaultPrincipal defaultPrincipal = securityHolder.getDefaultPrincipal();
            if (defaultPrincipal != null) {
                this.defaultSubject = ConfigurationUtil.generateDefaultSubject((DefaultPrincipal)defaultPrincipal, (ClassLoader)ctx.getWebClassLoader());
                ContextManager.registerSubject((Subject)this.defaultSubject);
                SubjectId id = ContextManager.getSubjectId((Subject)this.defaultSubject);
                this.defaultSubject.getPrincipals().add((Principal)new IdentificationPrincipal(id));
            }
            PolicyContextValve policyValve = new PolicyContextValve(securityHolder.getPolicyContextID());
            this.addValve((Valve)policyValve);
            boolean hasPermissions = securityHolder.getChecked().elements().hasMoreElements() || securityHolder.getExcluded().elements().hasMoreElements();
            DefaultSubjectValve defaultSubjectValve = !hasPermissions && this.defaultSubject != null ? new DefaultSubjectValve(this.defaultSubject) : new DefaultSubjectValve(null);
            this.addValve((Valve)defaultSubjectValve);
        }
        this.addValve((Valve)new SystemMethodValve());
        List valveChain = ctx.getValveChain();
        if (valveChain != null) {
            Iterator iterator = valveChain.iterator();
            while (iterator.hasNext()) {
                Valve valve = (Valve)iterator.next();
                this.addValve(valve);
            }
        }
        if ((cluster = ctx.getCluster()) != null) {
            this.setCluster((Cluster)cluster);
        }
        if ((manager = ctx.getManager()) != null) {
            this.setManager(manager);
        }
        this.pipelineInitialized = true;
        this.webServiceMap = ctx.getWebServices();
        this.setCrossContext(ctx.isCrossContext());
    }

    public synchronized void start() throws LifecycleException {
        if (this.pipelineInitialized) {
            try {
                Valve valve = this.getFirst();
                valve.invoke(null, null);
            }
            catch (IOException e) {
                if (e.getCause() instanceof LifecycleException) {
                    throw (LifecycleException)e.getCause();
                }
                throw new LifecycleException((Throwable)e);
            }
            catch (ServletException e) {
                throw new LifecycleException((Throwable)e);
            }
        } else {
            super.start();
        }
    }

    public synchronized void stop() throws LifecycleException {
        if (this.defaultSubject != null) {
            ContextManager.unregisterSubject((Subject)this.defaultSubject);
        }
        super.stop();
    }

    public void addChild(Container child) {
        block5: {
            Wrapper wrapper = (Wrapper)child;
            String servletClassName = wrapper.getServletClass();
            if (servletClassName == null) {
                super.addChild(child);
                return;
            }
            ClassLoader cl = this.getParentClassLoader();
            Class<?> baseServletClass = null;
            Class<?> servletClass = null;
            try {
                StoredObject storedObject;
                baseServletClass = cl.loadClass(Servlet.class.getName());
                servletClass = cl.loadClass(servletClassName);
                if (baseServletClass.isAssignableFrom(servletClass) || this.webServiceMap == null || (storedObject = (StoredObject)this.webServiceMap.get(wrapper.getName())) == null) break block5;
                WebServiceContainer webServiceContainer = null;
                try {
                    webServiceContainer = (WebServiceContainer)storedObject.getObject(cl);
                }
                catch (IOException io) {
                    throw new RuntimeException(io);
                }
                wrapper.setServletClass("org.apache.geronimo.webservices.POJOWebServiceServlet");
                String webServicecontainerID = wrapper.getName() + WebServiceContainerInvoker.WEBSERVICE_CONTAINER + webServiceContainer.hashCode();
                this.getServletContext().setAttribute(webServicecontainerID, (Object)webServiceContainer);
                wrapper.addInitParameter(WebServiceContainerInvoker.WEBSERVICE_CONTAINER, webServicecontainerID);
                String pojoClassID = wrapper.getName() + POJOWebServiceServlet.POJO_CLASS + servletClass.hashCode();
                this.getServletContext().setAttribute(pojoClassID, servletClass);
                wrapper.addInitParameter(POJOWebServiceServlet.POJO_CLASS, pojoClassID);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        super.addChild(child);
    }

    private class SystemMethodValve
    extends ValveBase {
        private SystemMethodValve() {
        }

        public void invoke(Request request, Response response) throws IOException, ServletException {
            if (request == null && response == null) {
                try {
                    GeronimoStandardContext.super.start();
                }
                catch (LifecycleException e) {
                    throw (IOException)new IOException("wrapping lifecycle exception").initCause(e);
                }
            } else {
                this.getNext().invoke(request, response);
            }
        }
    }
}

