/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Connector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.tomcat.BaseGBean;
import org.apache.geronimo.tomcat.ObjectRetriever;
import org.apache.geronimo.tomcat.TomcatContainer;
import org.apache.geronimo.tomcat.TomcatWebConnector;

public class ConnectorGBean
extends BaseGBean
implements GBeanLifecycle,
ObjectRetriever,
TomcatWebConnector {
    private static final Log log = LogFactory.getLog((Class)ConnectorGBean.class);
    public static final String CONNECTOR_CONTAINER_REFERENCE = "TomcatContainer";
    protected final Connector connector;
    private final TomcatContainer container;
    private String name;
    private String connectHost;
    public static final GBeanInfo GBEAN_INFO;

    public ConnectorGBean(String name, String protocol, String host, int port, TomcatContainer container) throws Exception {
        HashMap<String, String> initParams = new HashMap<String, String>();
        this.validateProtocol(protocol);
        if (host == null) {
            host = "0.0.0.0";
        }
        if (port == 0) {
            throw new IllegalArgumentException("Must declare a port.");
        }
        initParams.put("address", host);
        initParams.put("port", Integer.toString(port));
        this.initializeParams(protocol, initParams);
        protocol = protocol != null && protocol.equals("AJP") ? "AJP/1.3" : null;
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (container == null) {
            throw new IllegalArgumentException("container cannot be null.");
        }
        this.name = name;
        this.container = container;
        this.connector = new Connector(protocol);
        this.setParameters(this.connector, initParams);
    }

    protected void initializeParams(String protocol, Map params) {
    }

    protected void validateProtocol(String protocol) {
        if (protocol == null) {
            return;
        }
        if (protocol.equals("HTTPS")) {
            throw new IllegalArgumentException("Use a HttpsConnectorGBean for an HTTPS connector");
        }
        if (!protocol.equals("HTTP") && !protocol.equals("AJP")) {
            throw new IllegalArgumentException("Unrecognized protocol '" + protocol + "' (use the values of the PROTOCOL_* constants in WebConnector)");
        }
    }

    public String getName() {
        return this.name;
    }

    public Object getInternalObject() {
        return this.connector;
    }

    public void doStart() throws LifecycleException {
        this.container.addConnector(this.connector);
        this.connector.start();
        log.debug((Object)(this.name + " connector started"));
    }

    public void doStop() {
        try {
            this.connector.stop();
        }
        catch (LifecycleException e) {
            log.error((Object)e);
        }
        this.container.removeConnector(this.connector);
        log.debug((Object)(this.name + " connector stopped"));
    }

    public void doFail() {
        log.warn((Object)(this.name + " connector failed"));
        this.doStop();
    }

    public int getDefaultPort() {
        return this.getProtocol().equals("AJP") ? -1 : (this.getProtocol().equals("HTTP") ? 80 : (this.getProtocol().equals("HTTPS") ? 443 : -1));
    }

    public String getConnectUrl() {
        if (this.connectHost == null) {
            String host = this.getHost();
            if (host == null || host.equals("0.0.0.0")) {
                InetAddress address = null;
                try {
                    address = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    host = "unknown-host";
                }
                if (address != null && ((host = address.getHostName()) == null || host.equals(""))) {
                    host = address.getHostAddress();
                }
            }
            this.connectHost = host;
        }
        return this.getProtocol().toLowerCase() + "://" + this.connectHost + (this.getPort() == this.getDefaultPort() ? "" : ":" + this.getPort());
    }

    public String getProtocol() {
        String protocol = this.connector.getProtocol();
        if (protocol.indexOf("AJP") > -1) {
            return "AJP";
        }
        if (this.connector.getScheme().equalsIgnoreCase("http")) {
            return "HTTP";
        }
        if (this.connector.getScheme().equalsIgnoreCase("https")) {
            return "HTTPS";
        }
        throw new IllegalStateException("Unknown protocol '" + protocol + "' and scheme '" + this.connector.getScheme() + "'");
    }

    public int getPort() {
        return this.connector.getPort();
    }

    public void setPort(int port) {
        this.connector.setPort(port);
    }

    public String getHost() {
        Object value = this.connector.getAttribute("address");
        if (value == null) {
            return "0.0.0.0";
        }
        if (value instanceof InetAddress) {
            return ((InetAddress)value).getHostAddress();
        }
        return value.toString();
    }

    public void setHost(String host) throws UnknownHostException {
        this.connector.setAttribute("address", (Object)host);
    }

    public InetSocketAddress getListenAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }

    public int getBufferSizeBytes() {
        Object value = this.connector.getAttribute("bufferSize");
        return value == null ? 2048 : Integer.parseInt(value.toString());
    }

    public void setBufferSizeBytes(int bytes) {
        this.connector.setAttribute("bufferSize", (Object)new Integer(bytes));
    }

    public int getMaxThreads() {
        Object value = this.connector.getAttribute("maxThreads");
        return value == null ? 200 : Integer.parseInt(value.toString());
    }

    public void setMaxThreads(int threads) {
        this.connector.setAttribute("maxThreads", (Object)new Integer(threads));
    }

    public int getAcceptQueueSize() {
        Object value = this.connector.getAttribute("acceptCount");
        return value == null ? 10 : Integer.parseInt(value.toString());
    }

    public void setAcceptQueueSize(int size) {
        this.connector.setAttribute("acceptCount", (Object)new Integer(size));
    }

    public int getLingerMillis() {
        Object value = this.connector.getAttribute("connectionLinger");
        return value == null ? -1 : Integer.parseInt(value.toString());
    }

    public void setLingerMillis(int millis) {
        this.connector.setAttribute("connectionLinger", (Object)new Integer(millis));
    }

    public boolean isTcpNoDelay() {
        Object value = this.connector.getAttribute("tcpNoDelay");
        return value == null ? true : new Boolean(value.toString());
    }

    public void setTcpNoDelay(boolean enable) {
        this.connector.setAttribute("tcpNoDelay", (Object)new Boolean(enable));
    }

    public int getRedirectPort() {
        Object value = this.connector.getAttribute("redirectPort");
        return value == null ? 0 : Integer.parseInt(value.toString());
    }

    public void setRedirectPort(int port) {
        this.connector.setAttribute("redirectPort", (Object)new Integer(port));
    }

    public int getMinSpareThreads() {
        Object value = this.connector.getAttribute("minSpareThreads");
        return value == null ? 4 : Integer.parseInt(value.toString());
    }

    public void setMinSpareThreads(int threads) {
        this.connector.setAttribute("minSpareThreads", (Object)new Integer(threads));
    }

    public int getMaxSpareThreads() {
        Object value = this.connector.getAttribute("maxSpareThreads");
        return value == null ? 50 : Integer.parseInt(value.toString());
    }

    public void setMaxSpareThreads(int threads) {
        this.connector.setAttribute("maxSpareThreads", (Object)new Integer(threads));
    }

    public int getMaxHttpHeaderSizeBytes() {
        Object value = this.connector.getAttribute("maxHttpHeaderSize");
        return value == null ? 4096 : Integer.parseInt(value.toString());
    }

    public void setMaxHttpHeaderSizeBytes(int bytes) {
        this.connector.setAttribute("maxHttpHeaderSize", (Object)new Integer(bytes));
    }

    public boolean isHostLookupEnabled() {
        Object value = this.connector.getAttribute("enableLookups");
        return value == null ? true : new Boolean(value.toString());
    }

    public void setHostLookupEnabled(boolean enabled) {
        this.connector.setAttribute("enableLookups", (Object)new Boolean(enabled));
    }

    public int getConnectionTimeoutMillis() {
        Object value = this.connector.getAttribute("connectionTimeout");
        return value == null ? 60000 : Integer.parseInt(value.toString());
    }

    public void setConnectionTimeoutMillis(int millis) {
        this.connector.setAttribute("connectionTimeout", (Object)new Integer(millis));
    }

    public boolean isUploadTimeoutEnabled() {
        Object value = this.connector.getAttribute("disableUploadTimeout");
        return value == null ? true : new Boolean(value.toString()) == false;
    }

    public void setUploadTimeoutEnabled(boolean enabled) {
        this.connector.setAttribute("disableUploadTimeout", (Object)new Boolean(!enabled));
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Tomcat Connector", (Class)ConnectorGBean.class);
        infoFactory.addAttribute("name", String.class, true);
        infoFactory.addAttribute("protocol", String.class, true);
        infoFactory.addReference(CONNECTOR_CONTAINER_REFERENCE, TomcatContainer.class, "GBean");
        infoFactory.addOperation("getInternalObject");
        infoFactory.addInterface(TomcatWebConnector.class, new String[]{"host", "port", "bufferSizeBytes", "maxThreads", "acceptQueueSize", "lingerMillis", "tcpNoDelay", "redirectPort", "minSpareThreads", "maxSpareThreads", "maxHttpHeaderSizeBytes", "hostLookupEnabled", "connectionTimeoutMillis", "uploadTimeoutEnabled", "connectUrl"}, new String[]{"host", "port", "redirectPort"});
        infoFactory.setConstructor(new String[]{"name", "protocol", "host", "port", CONNECTOR_CONTAINER_REFERENCE});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

