/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.repository;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.WaitingException;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class ReadOnlyRepository
implements Repository,
GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)ReadOnlyRepository.class);
    private final URI root;
    private final ServerInfo serverInfo;
    private URI rootURI;
    public static final GBeanInfo GBEAN_INFO;

    public ReadOnlyRepository(File root) {
        this(root.toURI());
    }

    public ReadOnlyRepository(URI rootURI) {
        this.root = null;
        this.serverInfo = null;
        this.rootURI = rootURI;
    }

    public ReadOnlyRepository(URI root, ServerInfo serverInfo) {
        this.root = root;
        this.serverInfo = serverInfo;
    }

    public boolean hasURI(URI uri) {
        if ("file".equals((uri = this.rootURI.resolve(uri)).getScheme())) {
            File f = new File(uri);
            return f.exists() && f.canRead();
        }
        try {
            uri.toURL().openStream().close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public URL getURL(URI uri) throws MalformedURLException {
        return this.rootURI.resolve(uri).toURL();
    }

    public void doStart() throws WaitingException, Exception {
        if (this.rootURI == null) {
            this.rootURI = this.serverInfo.resolve(this.root);
        }
        log.info((Object)("Repository root is " + this.rootURI));
    }

    public void doStop() throws WaitingException, Exception {
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(ReadOnlyRepository.class);
        infoFactory.addAttribute("root", URI.class, true);
        infoFactory.addReference("ServerInfo", ServerInfo.class);
        infoFactory.addInterface(Repository.class);
        infoFactory.setConstructor(new String[]{"root", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

