/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import [Ljava.lang.String;;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.Iterator;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.log.GeronimoLogging;
import org.apache.geronimo.system.main.CommandLineManifest;
import org.apache.geronimo.system.url.GeronimoURLFactory;

public class CommandLine {
    private static Log log;

    private CommandLine() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        log.info((Object)"Server startup begun");
        try {
            CommandLineManifest manifest = CommandLineManifest.getManifestEntries();
            Kernel kernel = new Kernel("geronimo.kernel", "geronimo");
            kernel.boot();
            ConfigurationManager configurationManager = kernel.getConfigurationManager();
            GBeanMBean config = new GBeanMBean(Configuration.GBEAN_INFO);
            ClassLoader classLoader = CommandLine.class.getClassLoader();
            ObjectInputStream ois = new ObjectInputStream(classLoader.getResourceAsStream("META-INF/config.ser"));
            try {
                Configuration.loadGMBeanState((GBeanMBean)config, (ObjectInputStream)ois);
            }
            finally {
                ois.close();
            }
            ObjectName configName = configurationManager.load(config, classLoader.getResource("/"));
            kernel.startRecursiveGBean(configName);
            Iterator iterator = manifest.getConfigurations().iterator();
            while (iterator.hasNext()) {
                URI configurationID = (URI)iterator.next();
                ObjectName configurationName = configurationManager.load(configurationID);
                kernel.startRecursiveGBean(configurationName);
            }
            log.info((Object)"Server startup completed");
            kernel.invoke(manifest.getMainGBean(), manifest.getMainMethod(), new Object[]{args}, new String[]{String;.class.getName()});
            log.info((Object)"Server shutdown begun");
            kernel.stopGBean(configName);
            kernel.shutdown();
            log.info((Object)"Server shutdown completed");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
            throw new AssertionError();
        }
    }

    static {
        GeronimoLogging.initialize((GeronimoLogging)GeronimoLogging.ERROR);
        log = LogFactory.getLog((String)CommandLine.class.getName());
        GeronimoURLFactory.install();
    }
}

