/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.logging.log4j.appender;

import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.system.logging.log4j.PatternLayout;
import org.apache.geronimo.system.logging.log4j.XLevel;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;

public abstract class AbstractAppenderService
implements GBeanLifecycle {
    protected final WriterAppender appender;
    public static final GBeanInfo GBEAN_INFO;

    public AbstractAppenderService(WriterAppender appender) {
        this.appender = appender;
        appender.setLayout((Layout)new PatternLayout());
    }

    public void doStart() {
        this.appender.activateOptions();
        Logger root = Logger.getRootLogger();
        root.addAppender((Appender)this.appender);
    }

    public void doStop() {
        Logger root = Logger.getRootLogger();
        root.removeAppender((Appender)this.appender);
    }

    public void doFail() {
        this.doStop();
    }

    public String getLayoutPattern() {
        PatternLayout layout = (PatternLayout)this.appender.getLayout();
        return layout.getConversionPattern();
    }

    public void setLayoutPattern(String pattern) {
        PatternLayout layout = (PatternLayout)this.appender.getLayout();
        layout.setConversionPattern(pattern);
    }

    public String getThreshold() {
        return this.appender.getThreshold().toString();
    }

    public void setThreshold(String threshold) {
        this.appender.setThreshold((Priority)XLevel.toLevel(threshold));
    }

    public String getEncoding() {
        return this.appender.getEncoding();
    }

    public void setEncoding(String value) {
        this.appender.setEncoding(value);
    }

    public void setImmediateFlush(boolean value) {
        this.appender.setImmediateFlush(value);
    }

    public boolean getImmediateFlush() {
        return this.appender.getImmediateFlush();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(AbstractAppenderService.class);
        infoFactory.addAttribute("layoutPattern", String.class, true);
        infoFactory.addAttribute("threshold", String.class, true);
        infoFactory.addAttribute("encoding", String.class, true);
        infoFactory.addAttribute("immedateFlush", Boolean.TYPE, true);
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

