/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.logging.log4j;

import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.log.GeronimoLogFactory;
import org.apache.geronimo.system.logging.log4j.CachingLog4jLog;
import org.apache.geronimo.system.logging.log4j.URLConfigurator;
import org.apache.geronimo.system.logging.log4j.XLevel;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Log4jService
implements GBeanLifecycle {
    private String configurationFile;
    private int refreshPeriod;
    private ServerInfo serverInfo;
    private Timer timer = new Timer(true);
    private TimerTask monitor;
    private long lastChanged = -1L;
    private Level rootLoggerLevel;
    private boolean running = false;
    public static final GBeanInfo GBEAN_INFO;

    public Log4jService(String rootLoggerLevel, String configurationFile, int refreshPeroid, ServerInfo serverInfo) {
        LogFactory logFactory = LogFactory.getFactory();
        if (!(logFactory instanceof GeronimoLogFactory)) {
            throw new IllegalStateException("Commons log factory: " + logFactory + " is not a GeronimoLogFactory");
        }
        this.rootLoggerLevel = XLevel.toLevel(rootLoggerLevel);
        this.refreshPeriod = refreshPeroid;
        this.configurationFile = configurationFile;
        this.serverInfo = serverInfo;
    }

    public synchronized String getRootLoggerLevel() {
        if (this.rootLoggerLevel != null) {
            return this.rootLoggerLevel.toString();
        }
        return null;
    }

    public synchronized void setRootLoggerLevel(String level) {
        if (level == null) {
            this.rootLoggerLevel = null;
        } else {
            this.rootLoggerLevel = XLevel.toLevel(level);
            if (this.running) {
                Logger.getRootLogger().setLevel(this.rootLoggerLevel);
            }
        }
    }

    public String getLoggerLevel(String logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger is null");
        }
        Level level = Logger.getLogger((String)logger).getLevel();
        if (level != null) {
            return level.toString();
        }
        return null;
    }

    public void setLoggerLevel(String logger, String level) {
        if (logger == null) {
            throw new IllegalArgumentException("logger is null");
        }
        if (level == null) {
            throw new IllegalArgumentException("level is null");
        }
        Logger.getLogger((String)logger).setLevel(XLevel.toLevel(level));
    }

    public synchronized int getRefreshPeriod() {
        return this.refreshPeriod;
    }

    public synchronized void setRefreshPeriod(int period) {
        if (period < 1) {
            throw new IllegalArgumentException("Refresh period must be > 0");
        }
        if (this.refreshPeriod != period) {
            this.refreshPeriod = period;
            this.schedule();
        }
    }

    public synchronized String getConfigurationFile() {
        return this.configurationFile;
    }

    public synchronized void setConfigurationFile(String configurationFile) {
        if (this.configurationFile == null) {
            throw new IllegalArgumentException("configurationFile is null");
        }
        this.configurationFile = configurationFile;
    }

    public void reconfigure() {
        URL url = this.resolveURL();
        if (url == null) {
            return;
        }
        URLConfigurator.configure(url);
    }

    private synchronized void schedule() {
        if (this.timer != null) {
            if (this.monitor != null) {
                this.monitor.cancel();
            }
            TimerTask task = this.monitor = new URLMonitorTask();
            this.timer.schedule(this.monitor, 1000 * this.refreshPeriod, (long)(1000 * this.refreshPeriod));
            task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() {
        GeronimoLogFactory logFactory;
        Log4jService log4jService = this;
        synchronized (log4jService) {
            this.schedule();
            Logger.getRootLogger();
            if (this.rootLoggerLevel != null) {
                Logger.getRootLogger().setLevel(this.rootLoggerLevel);
            }
            this.reconfigure();
        }
        Object object = logFactory = (GeronimoLogFactory)LogFactory.getFactory();
        synchronized (object) {
            if (!(logFactory.getLogFactory() instanceof CachingLog4jLogFactory)) {
                logFactory.setLogFactory((LogFactory)new CachingLog4jLogFactory());
            }
        }
        object = this;
        synchronized (object) {
            this.running = true;
        }
    }

    public synchronized void doStop() {
        this.running = false;
        if (this.monitor != null) {
            this.monitor.cancel();
            this.monitor = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void doFail() {
        this.doStop();
    }

    private synchronized URL resolveURL() {
        try {
            return this.serverInfo.resolve(URI.create(this.configurationFile)).toURL();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(Log4jService.class);
        infoFactory.addAttribute("rootLoggerLevel", String.class, true);
        infoFactory.addAttribute("configurationFile", String.class, true);
        infoFactory.addAttribute("refreshPeriod", Integer.TYPE, true);
        infoFactory.addReference("ServerInfo", ServerInfo.class);
        infoFactory.addOperation("reconfigure");
        infoFactory.addOperation("setLoggerLevel", new Class[]{String.class, String.class});
        infoFactory.addOperation("getLoggerLevel", new Class[]{String.class});
        infoFactory.setConstructor(new String[]{"rootLoggerLevel", "configurationFile", "refreshPeriod", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private static class CachingLog4jLogFactory
    extends LogFactory {
        private CachingLog4jLogFactory() {
        }

        public Log getInstance(Class clazz) throws LogConfigurationException {
            return this.getInstance(clazz.getName());
        }

        public Log getInstance(String name) throws LogConfigurationException {
            return new CachingLog4jLog(name);
        }

        public Object getAttribute(String name) {
            return null;
        }

        public String[] getAttributeNames() {
            return new String[0];
        }

        public void release() {
        }

        public void removeAttribute(String name) {
        }

        public void setAttribute(String name, Object value) {
        }
    }

    private class URLMonitorTask
    extends TimerTask {
        private URLMonitorTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                long lastModified;
                URLMonitorTask uRLMonitorTask = this;
                synchronized (uRLMonitorTask) {
                    if (!Log4jService.this.running) {
                        return;
                    }
                    URL url = Log4jService.this.resolveURL();
                    if (url == null) {
                        return;
                    }
                    URLConnection connection = url.openConnection();
                    lastModified = connection.getLastModified();
                }
                if (Log4jService.this.lastChanged < lastModified) {
                    Log4jService.this.lastChanged = lastModified;
                    Log4jService.this.reconfigure();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

