/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.WaitingException;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class LocalConfigStore
implements ConfigurationStore,
GBeanLifecycle {
    private static final String INDEX_NAME = "index.properties";
    private final String objectName;
    private final URI root;
    private final ServerInfo serverInfo;
    private final Properties index = new Properties();
    private final Log log;
    private File rootDir;
    private int maxId;
    public static final GBeanInfo GBEAN_INFO;

    public LocalConfigStore(File rootDir) {
        this.objectName = null;
        this.serverInfo = null;
        this.root = null;
        this.rootDir = rootDir;
        this.log = LogFactory.getLog((String)("LocalConfigStore:" + rootDir.getName()));
    }

    public LocalConfigStore(String objectName, URI root, ServerInfo serverInfo) {
        this.objectName = objectName;
        this.root = root;
        this.serverInfo = serverInfo;
        this.log = LogFactory.getLog((String)("LocalConfigStore:" + root.toString()));
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void doStart() throws WaitingException, FileNotFoundException, IOException {
        if (this.rootDir == null) {
            this.rootDir = new File(this.serverInfo.resolve(this.root));
            if (!this.rootDir.isDirectory()) {
                throw new FileNotFoundException("Store root does not exist or is not a directory: " + this.rootDir);
            }
        }
        this.index.clear();
        File indexfile = new File(this.rootDir, INDEX_NAME);
        try {
            this.index.load(new BufferedInputStream(new FileInputStream(indexfile)));
            Iterator<Object> i = this.index.values().iterator();
            while (i.hasNext()) {
                String id = (String)i.next();
                this.maxId = Math.max(this.maxId, Integer.parseInt(id));
            }
        }
        catch (FileNotFoundException e) {
            this.maxId = 0;
        }
    }

    public void doStop() throws WaitingException {
    }

    public void doFail() {
    }

    private void saveIndex() throws IOException {
        File indexFile = new File(this.rootDir, INDEX_NAME);
        File tmpFile = File.createTempFile("index", ".tmp", this.rootDir);
        FileOutputStream fos = new FileOutputStream(tmpFile);
        try {
            BufferedOutputStream os = new BufferedOutputStream(fos);
            this.index.store(os, null);
            os.close();
            fos = null;
            indexFile.delete();
            tmpFile.renameTo(indexFile);
        }
        catch (IOException e) {
            if (fos != null) {
                fos.close();
            }
            tmpFile.delete();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI install(URL source) throws IOException, InvalidConfigException {
        URI configId;
        String newId;
        LocalConfigStore localConfigStore = this;
        synchronized (localConfigStore) {
            newId = Integer.toString(++this.maxId);
        }
        File bundleRoot = new File(this.rootDir, newId);
        bundleRoot.mkdir();
        InputStream is = source.openStream();
        try {
            LocalConfigStore.unpack(bundleRoot, is);
        }
        finally {
            is.close();
        }
        try {
            GBeanMBean config = this.loadConfig(bundleRoot);
            configId = (URI)config.getAttribute("ID");
            this.index.setProperty(configId.toString(), newId);
        }
        catch (Exception e) {
            LocalConfigStore.delete(bundleRoot);
            throw new InvalidConfigException("Unable to get ID from downloaded configuration", (Throwable)e);
        }
        LocalConfigStore localConfigStore2 = this;
        synchronized (localConfigStore2) {
            this.saveIndex();
        }
        this.log.info((Object)("Installed configuration " + configId + " in location " + newId));
        return configId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall(URI configID) throws NoSuchConfigException, IOException {
        File configDir;
        String id = configID.toString();
        LocalConfigStore localConfigStore = this;
        synchronized (localConfigStore) {
            String storeID = this.index.getProperty(id);
            if (storeID == null) {
                throw new NoSuchConfigException();
            }
            configDir = new File(this.rootDir, storeID);
            File tempDir = new File(this.rootDir, storeID + ".tmp");
            if (configDir.renameTo(tempDir)) {
                configDir = tempDir;
            }
            this.index.remove(id);
            this.saveIndex();
        }
        this.log.info((Object)("Uninstalled configuration " + configID));
        LocalConfigStore.delete(configDir);
    }

    public synchronized GBeanMBean getConfiguration(URI configID) throws NoSuchConfigException, IOException, InvalidConfigException {
        return this.loadConfig(this.getRoot(configID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listConfiguations() {
        ArrayList<URI> configs;
        LocalConfigStore localConfigStore = this;
        synchronized (localConfigStore) {
            configs = new ArrayList<URI>(this.index.size());
            Iterator<Object> i = this.index.keySet().iterator();
            while (i.hasNext()) {
                String id = (String)i.next();
                configs.add(URI.create(id));
            }
        }
        return configs;
    }

    public URL getBaseURL(URI configID) throws NoSuchConfigException {
        File root = this.getRoot(configID);
        try {
            return root.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Unable to turn config root into URL: " + root);
        }
    }

    public synchronized boolean containsConfiguration(URI configID) {
        return this.index.getProperty(configID.toString()) != null;
    }

    private synchronized File getRoot(URI configID) throws NoSuchConfigException {
        String id = this.index.getProperty(configID.toString());
        if (id == null) {
            throw new NoSuchConfigException("No such config: " + configID);
        }
        return new File(this.rootDir, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GBeanMBean loadConfig(File configRoot) throws IOException, InvalidConfigException {
        FileInputStream fis = new FileInputStream(new File(configRoot, "META-INF/config.ser"));
        try {
            GBeanMBean config;
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(fis));
            try {
                config = new GBeanMBean(Configuration.GBEAN_INFO);
            }
            catch (InvalidConfigurationException e) {
                throw new InvalidConfigException("Unable to instantiate Configuration GBeanMBean", (Throwable)e);
            }
            try {
                Configuration.loadGMBeanState((GBeanMBean)config, (ObjectInputStream)ois);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidConfigException("Unable to read attribute ", (Throwable)e);
            }
            catch (Exception e) {
                throw new InvalidConfigException("Unable to set attribute ", (Throwable)e);
            }
            GBeanMBean gBeanMBean = config;
            return gBeanMBean;
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpack(File to, InputStream from) throws IOException {
        ZipInputStream zis = new ZipInputStream(from);
        try {
            ZipEntry entry;
            byte[] buffer = new byte[4096];
            while ((entry = zis.getNextEntry()) != null) {
                File out = new File(to, entry.getName());
                if (entry.isDirectory()) {
                    out.mkdirs();
                    continue;
                }
                if (entry.getName().equals("META-INF/startup-jar")) continue;
                out.getParentFile().mkdirs();
                FileOutputStream os = new FileOutputStream(out);
                try {
                    int count;
                    while ((count = zis.read(buffer)) > 0) {
                        ((OutputStream)os).write(buffer, 0, count);
                    }
                }
                finally {
                    ((OutputStream)os).close();
                }
                zis.closeEntry();
            }
        }
        catch (IOException e) {
            LocalConfigStore.delete(to);
            throw e;
        }
    }

    private static void delete(File root) throws IOException {
        File[] files = root.listFiles();
        if (null == files) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                LocalConfigStore.delete(file);
                continue;
            }
            if (file.delete()) continue;
            file.deleteOnExit();
        }
        root.delete();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(LocalConfigStore.class);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addAttribute("root", URI.class, true);
        infoFactory.addReference("ServerInfo", ServerInfo.class);
        infoFactory.addInterface(ConfigurationStore.class);
        infoFactory.setConstructor(new String[]{"objectName", "root", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

