/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.WaitingException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationInfo;
import org.apache.geronimo.kernel.config.NoSuchStoreException;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.kernel.management.State;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class FileConfigurationList
implements GBeanLifecycle,
PersistentConfigurationList {
    private static final Log log = LogFactory.getLog((Class)PersistentConfigurationList.class);
    private final Kernel kernel;
    private final ServerInfo serverInfo;
    private final String configFile;
    private File configList;
    private Runnable hook;
    public static final GBeanInfo GBEAN_INFO;

    public FileConfigurationList(Kernel kernel, ServerInfo serverInfo, String configDir) {
        this.kernel = kernel;
        this.serverInfo = serverInfo;
        this.configFile = configDir;
    }

    public void doStart() throws WaitingException, Exception {
        this.configList = this.serverInfo.resolve(this.configFile);
        File parent = this.configList.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            throw new IOException("Unable to create directory for list:" + parent);
        }
        this.hook = new Runnable(){

            public void run() {
                try {
                    FileConfigurationList.this.save();
                }
                catch (IOException e) {
                    log.error((Object)"Unable to save configuration on shutdown", (Throwable)e);
                }
            }
        };
        this.kernel.registerShutdownHook(this.hook);
    }

    public void doStop() throws Exception {
        this.doFail();
    }

    public void doFail() {
        this.kernel.unregisterShutdownHook(this.hook);
        this.hook = null;
        this.configList = null;
    }

    public synchronized void save() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.configList));
        try {
            List stores = this.kernel.listConfigurationStores();
            Iterator i = stores.iterator();
            while (i.hasNext()) {
                ObjectName storeName = (ObjectName)i.next();
                List configList = this.kernel.listConfigurations(storeName);
                Iterator j = configList.iterator();
                while (j.hasNext()) {
                    ConfigurationInfo info = (ConfigurationInfo)j.next();
                    if (info.getState() != State.RUNNING) continue;
                    writer.write(info.getConfigID().toString());
                    writer.newLine();
                }
            }
            writer.close();
        }
        catch (NoSuchStoreException e) {
            writer.close();
            this.configList.delete();
        }
        log.info((Object)"Saved running configuration list");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List restore() throws IOException {
        FileReader fileReader;
        try {
            fileReader = new FileReader(this.configList);
        }
        catch (FileNotFoundException e) {
            return Collections.EMPTY_LIST;
        }
        BufferedReader reader = new BufferedReader(fileReader);
        try {
            String line;
            ArrayList<URI> configs = new ArrayList<URI>();
            while ((line = reader.readLine()) != null) {
                try {
                    configs.add(new URI(line));
                }
                catch (URISyntaxException e) {
                    throw new IOException("Invalid URI in config list: " + line);
                }
            }
            ArrayList<URI> arrayList = configs;
            return arrayList;
        }
        finally {
            reader.close();
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(FileConfigurationList.class);
        infoFactory.addInterface(PersistentConfigurationList.class);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addReference("ServerInfo", ServerInfo.class);
        infoFactory.addAttribute("configFile", String.class, true);
        infoFactory.setConstructor(new String[]{"kernel", "ServerInfo", "configFile"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

