/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system;

import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.WaitingException;

public class RMIRegistryService
implements GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)RMIRegistryService.class);
    private int port = 1099;
    private Registry registry;
    public static final GBeanInfo GBEAN_INFO;

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void doStart() throws WaitingException, Exception {
        this.registry = LocateRegistry.createRegistry(this.port);
        log.info((Object)("Started RMI Registry on port " + this.port));
    }

    public void doStop() throws WaitingException, Exception {
        UnicastRemoteObject.unexportObject(this.registry, true);
        log.info((Object)"Stopped RMI Registry");
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception e) {
            log.warn((Object)"RMI Registry failed");
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(RMIRegistryService.class);
        infoFactory.addAttribute("port", Integer.TYPE, true);
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

