/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.serverinfo;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GConstructorInfo;
import org.apache.geronimo.system.serverinfo.ServerConstants;

public class ServerInfo {
    private final File base;
    private final URI baseURI;
    private static final GBeanInfo GBEAN_INFO;

    public ServerInfo() {
        this.base = null;
        this.baseURI = null;
    }

    public ServerInfo(String baseDirectory) throws Exception {
        ServerConstants.getVersion();
        baseDirectory = System.getProperty("geronimo.base.dir", baseDirectory);
        if (baseDirectory == null || baseDirectory.length() == 0) {
            URL url = this.getClass().getClassLoader().getResource("META-INF/startup-jar");
            if (url == null) {
                throw new IllegalArgumentException("Unable to determine location of startup jar");
            }
            try {
                JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                url = jarConnection.getJarFileURL();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to extract base URL from location");
            }
            this.baseURI = new URI(url.toString()).resolve("..");
            this.base = new File(this.baseURI);
        } else {
            this.base = new File(baseDirectory);
            this.baseURI = this.base.toURI();
        }
        if (!this.base.isDirectory()) {
            throw new IllegalArgumentException("Base directory is not a directory: " + baseDirectory);
        }
    }

    public String resolvePath(String filename) {
        File file = new File(this.base, filename);
        return file.getAbsolutePath();
    }

    public URI resolve(URI uri) {
        return this.baseURI.resolve(uri);
    }

    public String getBaseDirectory() {
        return this.base.getAbsolutePath();
    }

    public String getVersion() {
        return ServerConstants.getVersion();
    }

    public String getBuildDate() {
        return ServerConstants.getBuildDate();
    }

    public String getBuildTime() {
        return ServerConstants.getBuildTime();
    }

    public String getCopyright() {
        return ServerConstants.getCopyright();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(ServerInfo.class.getName());
        infoFactory.setConstructor(new GConstructorInfo(new String[]{"BaseDirectory"}, new Class[]{String.class}));
        infoFactory.addAttribute("BaseDirectory", true);
        infoFactory.addAttribute("Version", false);
        infoFactory.addAttribute("BuildDate", false);
        infoFactory.addAttribute("BuildTime", false);
        infoFactory.addAttribute("Copyright", false);
        infoFactory.addOperation("resolvePath", new Class[]{String.class});
        infoFactory.addOperation("resolve", new Class[]{URI.class});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

