/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.logging.log4j.appender;

import java.io.File;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GConstructorInfo;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.system.logging.log4j.appender.AbstractAppenderService;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.log4j.FileAppender;
import org.apache.log4j.WriterAppender;

public class FileAppenderService
extends AbstractAppenderService {
    private final ServerInfo serverInfo;
    private String file;
    private boolean running = false;
    public static final GBeanInfo GBEAN_INFO;

    public FileAppenderService(ServerInfo serverInfo) {
        this(serverInfo, new FileAppender());
    }

    public FileAppenderService(ServerInfo serverInfo, FileAppender appender) {
        super((WriterAppender)appender);
        this.serverInfo = serverInfo;
    }

    public boolean getAppend() {
        return ((FileAppender)this.appender).getAppend();
    }

    public void setAppend(boolean append) {
        ((FileAppender)this.appender).setAppend(append);
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
        if (this.running) {
            this.setAppenderFile(file);
        }
    }

    public void doStart() {
        this.running = true;
        this.setAppenderFile(this.file);
        super.doStart();
    }

    public void doStop() {
        super.doStop();
        this.running = false;
    }

    private void setAppenderFile(String file) {
        file = this.serverInfo.resolvePath(file);
        new File(file).getParentFile().mkdirs();
        ((FileAppender)this.appender).setFile(file);
    }

    public boolean getBufferedIO() {
        return ((FileAppender)this.appender).getBufferedIO();
    }

    public void setBufferedIO(boolean bufferedIO) {
        ((FileAppender)this.appender).setBufferedIO(bufferedIO);
    }

    public int getBufferSize() {
        return ((FileAppender)this.appender).getBufferSize();
    }

    public void setBufferSize(int bufferSize) {
        ((FileAppender)this.appender).setBufferSize(bufferSize);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(FileAppenderService.class.getName(), AbstractAppenderService.GBEAN_INFO);
        infoFactory.setConstructor(new GConstructorInfo(new String[]{"ServerInfo"}, new Class[]{ServerInfo.class}));
        infoFactory.addReference(new GReferenceInfo("ServerInfo", ServerInfo.class.getName()));
        infoFactory.addAttribute(new GAttributeInfo("Append", true));
        infoFactory.addAttribute(new GAttributeInfo("File", true));
        infoFactory.addAttribute(new GAttributeInfo("BufferedIO", true));
        infoFactory.addAttribute(new GAttributeInfo("BufferedSize", true));
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

