/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBean;
import org.apache.geronimo.gbean.GBeanContext;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.WaitingException;

public class ThreadPool
implements GBean {
    private static final Log log = LogFactory.getLog((Class)ThreadPool.class);
    private PooledExecutor workManager;
    private long keepAliveTime;
    private int minimumPoolSize;
    private int maximumPoolSize;
    private String poolName;
    private int nextWorkerID = 0;
    private static final GBeanInfo GBEAN_INFO;

    public Executor getWorkManager() {
        return this.workManager;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public int getMinimumPoolSize() {
        return this.minimumPoolSize;
    }

    public void setMinimumPoolSize(int minimumPoolSize) {
        this.minimumPoolSize = minimumPoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    private int getNextWorkerID() {
        return this.nextWorkerID++;
    }

    public void setGBeanContext(GBeanContext context) {
    }

    public void doStart() throws WaitingException, Exception {
        PooledExecutor p = new PooledExecutor();
        p.setKeepAliveTime(this.keepAliveTime);
        p.setMinimumPoolSize(this.minimumPoolSize);
        p.setMaximumPoolSize(this.maximumPoolSize);
        p.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable arg0) {
                return new Thread(arg0, ThreadPool.this.poolName + " " + ThreadPool.this.getNextWorkerID());
            }
        });
        this.workManager = p;
        log.info((Object)("Thread pool " + this.poolName + " started"));
    }

    public void doStop() throws WaitingException, Exception {
        this.workManager.shutdownNow();
        log.info((Object)("Thread pool " + this.poolName + " stopped"));
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(ThreadPool.class.getName());
        infoFactory.addAttribute("keepAliveTime", true);
        infoFactory.addAttribute("minimumPoolSize", true);
        infoFactory.addAttribute("maximumPoolSize", true);
        infoFactory.addAttribute("poolName", true);
        infoFactory.addOperation("getWorkManager");
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

