/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.spring;

import [Ljava.net.URI;;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.sf.cglib.proxy.InterfaceMaker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class SpringGBean
implements GBeanLifecycle {
    protected static final Log _log = LogFactory.getLog((Class)SpringGBean.class);
    protected final Kernel _kernel;
    protected final String _objectName;
    protected final ClassLoader _classLoader;
    protected final URI[] _classPath;
    protected final URL _configurationBaseUrl;
    protected final URI _configPath;
    protected ClassLoader _appClassLoader;
    protected ObjectName _jmxName;
    protected DefaultListableBeanFactory _factory;
    public static final GBeanInfo GBEAN_INFO;
    protected int _count = 0;

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    public SpringGBean(Kernel kernel, String objectName, ClassLoader classLoader, URI[] classPath, URL configurationBaseUrl, URI configPath) {
        this._kernel = kernel;
        this._objectName = objectName;
        this._configPath = configPath;
        this._classLoader = classLoader;
        this._classPath = classPath;
        this._configurationBaseUrl = configurationBaseUrl;
    }

    public void doStart() throws Exception {
        int n;
        this._jmxName = new ObjectName(this._objectName);
        URI root = URI.create(this._configurationBaseUrl.toString());
        URL[] urls = new URL[this._classPath.length];
        for (int i = 0; i < this._classPath.length; ++i) {
            URL url = root.resolve(this._classPath[i]).toURL();
            _log.info((Object)("_classPath[" + i + "]: " + url));
            urls[i] = url;
        }
        this._appClassLoader = new URLClassLoader(urls, this._classLoader);
        this._factory = new GeronimoBeanFactory();
        XmlBeanDefinitionReader xbdr = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this._factory);
        xbdr.setBeanClassLoader(this._appClassLoader);
        xbdr.loadBeanDefinitions((Resource)new ClassPathResource(this._configPath.toString(), this._appClassLoader));
        this._factory.addBeanPostProcessor(new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String name) throws BeansException {
                return SpringGBean.this.beforeInitialization(bean, name);
            }

            public Object postProcessAfterInitialization(Object bean, String name) throws BeansException {
                return SpringGBean.this.afterInitialization(bean, name);
            }
        });
        String[] ids = this._factory.getBeanDefinitionNames();
        for (int i = n = ids.length; i > 0; --i) {
            this._factory.getBean(ids[i - 1]);
        }
        _log.info((Object)("Deployed: " + n + " POJO" + (n == 1 ? "" : "s")));
    }

    public void doStop() throws Exception {
        this.tidyUp();
    }

    public void doFail() {
        try {
            this.tidyUp();
        }
        catch (Exception e) {
            _log.warn((Object)("problem decommissioning Spring module: " + this._jmxName), (Throwable)e);
        }
    }

    protected void tidyUp() throws Exception {
        String pattern = this._jmxName.getDomain() + ":J2EEApplication=" + this._jmxName.getKeyProperty("J2EEApplication") + ",J2EEServer=" + this._jmxName.getKeyProperty("J2EEServer") + ",SpringModule=" + this._jmxName.getKeyProperty("name") + ",j2eeType=SpringBean,*";
        ObjectName on = new ObjectName(pattern);
        Set peers = this._kernel.listGBeans(on);
        Iterator i = peers.iterator();
        while (i.hasNext()) {
            ObjectName tmp = (ObjectName)i.next();
            try {
                _log.info((Object)("stopping: " + tmp));
                this._kernel.stopGBean(tmp);
                _log.info((Object)("unloading: " + tmp));
                this._kernel.unloadGBean(tmp);
            }
            catch (Exception e) {
                _log.warn((Object)("problem decommissioning POJO peer GBean: " + tmp), (Throwable)e);
            }
        }
        this._factory.destroySingletons();
    }

    protected Object beforeInitialization(Object bean, String name) {
        return bean;
    }

    protected Object afterInitialization(Object bean, String name) throws BeansException {
        try {
            GBeanData gd = this.createPOJOGBeanData(bean, name);
            if (gd == null) {
                _log.warn((Object)("No GBean available for name: " + name + " bean: " + bean));
            } else {
                _log.info((Object)("proxying: " + bean));
                _log.info((Object)("loading: " + gd.getName()));
                this._kernel.loadGBean(gd, this._appClassLoader);
                _log.info((Object)("starting: " + gd.getName()));
                this._kernel.startGBean(gd.getName());
            }
        }
        catch (Exception e) {
            throw new BeanDefinitionValidationException("Could not load the GBean for name: " + name + " bean: " + bean + ". Reason: " + e, (Throwable)e);
        }
        return bean;
    }

    protected ObjectName createObjectName(String name) throws MalformedObjectNameException {
        Hashtable<String, String> props = new Hashtable<String, String>(this._jmxName.getKeyPropertyList());
        props.put("SpringModule", props.get("name"));
        props.put("j2eeType", "SpringBean");
        props.put("name", name);
        return new ObjectName(this._jmxName.getDomain(), props);
    }

    protected synchronized GBeanData createPOJOGBeanData(Object bean, String name) throws MalformedObjectNameException {
        Class c = this.createProxyClass(bean);
        GBeanInfoBuilder gbif = new GBeanInfoBuilder(c, "POJO[" + this._count++ + "]");
        gbif.addAttribute("invocationHandler", java.lang.reflect.InvocationHandler.class, true);
        gbif.setConstructor(new String[]{"invocationHandler"});
        HashSet<String> pm = new HashSet<String>();
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            String n = m.getName();
            Class<?>[] pt = m.getParameterTypes();
            Class<?> rt = m.getReturnType();
            if ((!n.startsWith("get") || pt.length != 0) && (!n.startsWith("set") || pt.length != 1 || rt != Void.TYPE)) continue;
            pm.add(n.substring(3, 4).toLowerCase() + n.substring(4));
        }
        gbif.addInterface(c, pm.toArray(new String[pm.size()]));
        GBeanData gbd = new GBeanData(this.createObjectName(name), gbif.getBeanInfo());
        gbd.setAttribute("invocationHandler", (Object)new InvocationHandler(bean));
        return gbd;
    }

    protected Class createProxyClass(Object pojo) {
        InterfaceMaker im = new InterfaceMaker();
        im.add(pojo.getClass());
        Class c = im.create();
        return Proxy.getProxyClass(c.getClassLoader(), c);
    }

    static {
        GBeanInfoBuilder infoBuilder = new GBeanInfoBuilder("Spring Application Context", SpringGBean.class);
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.addAttribute("objectName", String.class, false);
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.addAttribute("classPath", URI;.class, true);
        infoBuilder.addAttribute("configurationBaseUrl", URL.class, true);
        infoBuilder.addAttribute("configPath", URI.class, true);
        infoBuilder.setConstructor(new String[]{"kernel", "objectName", "classLoader", "classPath", "configurationBaseUrl", "configPath"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    public static class InvocationHandler
    implements java.lang.reflect.InvocationHandler,
    Serializable {
        protected Object _pojo;

        public InvocationHandler(Object pojo) {
            this._pojo = pojo;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this._pojo.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke(this._pojo, args);
        }
    }

    class GeronimoBeanFactory
    extends DefaultListableBeanFactory {
        GeronimoBeanFactory() {
        }
    }
}

