/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.spring;

import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.WaitingException;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.kernel.Kernel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class SpringGBean
implements GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)SpringGBean.class);
    private ObjectName objectName;
    private String url;
    private Kernel kernel;
    private XmlBeanFactory factory;

    public SpringGBean(Kernel kernel) {
        this.kernel = kernel;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void doStart() throws WaitingException, Exception {
        if (this.url == null) {
            throw new Exception("No URL specified, cannot load the Spring XML config file");
        }
        if (this.objectName == null) {
            throw new Exception("No objectName injected for this GBean by the kernel!");
        }
        this.factory = new XmlBeanFactory(this.createResource());
        this.factory.addBeanPostProcessor(new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String name) throws BeansException {
                return SpringGBean.this.beforeInitialization(bean, name);
            }

            public Object postProcessAfterInitialization(Object bean, String name) throws BeansException {
                return SpringGBean.this.afterInitialization(bean, name);
            }
        });
    }

    public void doStop() throws WaitingException, Exception {
        this.factory.destroySingletons();
    }

    public void doFail() {
        this.factory.destroySingletons();
    }

    protected Resource createResource() {
        return new ClassPathResource(this.url);
    }

    protected Object beforeInitialization(Object bean, String name) {
        return bean;
    }

    protected Object afterInitialization(Object bean, String name) throws BeansException {
        try {
            ObjectName objectName = this.createObjectName(name);
            GBeanMBean gbean = this.createGBean(bean, name);
            if (gbean == null) {
                log.warn((Object)("No GBean available for name: " + name + " bean: " + bean));
            } else {
                this.kernel.loadGBean(objectName, gbean);
            }
        }
        catch (Exception e) {
            throw new BeanDefinitionValidationException("Could not load the GBean for name: " + name + " bean: " + bean + ". Reason: " + e, (Throwable)e);
        }
        return bean;
    }

    protected ObjectName createObjectName(String name) throws MalformedObjectNameException {
        Hashtable<String, String> nameProps = new Hashtable<String, String>(this.objectName.getKeyPropertyList());
        nameProps.put("name", name);
        return new ObjectName(this.objectName.getDomain(), nameProps);
    }

    protected GBeanMBean createGBean(Object bean, String name) {
        return null;
    }
}

