/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.service;

import java.beans.PropertyEditor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.propertyeditor.PropertyEditors;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.service.XmlAttributeBuilder;
import org.apache.geronimo.deployment.service.XmlReferenceBuilder;
import org.apache.geronimo.deployment.xbeans.PatternType;
import org.apache.geronimo.deployment.xbeans.ReferenceType;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContext;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.xmlbeans.XmlObject;

public class GBeanBuilder {
    private final GBeanData gbean;
    private final ClassLoader classLoader;
    private final DeploymentContext context;
    private final J2eeContext j2eeContext;
    private final Map xmlAttributeBuilderMap;
    private final Map xmlReferenceBuilderMap;

    GBeanBuilder(ObjectName objectName, GBeanInfo gBeanInfo, ClassLoader classLoader, DeploymentContext context, J2eeContext j2eeContext, Map xmlAttributeBuilderMap, Map xmlReferenceBuilderMap) {
        this.classLoader = classLoader;
        this.context = context;
        this.j2eeContext = j2eeContext;
        this.gbean = new GBeanData(objectName, gBeanInfo);
        this.xmlAttributeBuilderMap = xmlAttributeBuilderMap;
        this.xmlReferenceBuilderMap = xmlReferenceBuilderMap;
    }

    public void setAttribute(String name, String type, String text) throws DeploymentException {
        if (text != null) {
            text = text.trim();
        }
        try {
            PropertyEditor editor;
            if (type == null) {
                GAttributeInfo attribute = this.gbean.getGBeanInfo().getAttribute(name);
                if (attribute == null) {
                    throw new DeploymentException("Unknown attribute " + name + " on " + this.gbean.getName());
                }
                type = attribute.getType();
            }
            if ((editor = PropertyEditors.findEditor((String)type, (ClassLoader)this.classLoader)) == null) {
                throw new DeploymentException("Unable to find PropertyEditor for " + type);
            }
            editor.setAsText(text);
            Object value = editor.getValue();
            this.gbean.setAttribute(name, value);
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Unable to find PropertyEditor for " + type, (Throwable)e);
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to set attribute " + name + " to " + text, (Throwable)e);
        }
    }

    public void setXmlAttribute(String name, XmlObject xmlObject) throws DeploymentException {
        String namespace = xmlObject.getDomNode().getNamespaceURI();
        XmlAttributeBuilder builder = (XmlAttributeBuilder)this.xmlAttributeBuilderMap.get(namespace);
        if (builder == null) {
            throw new DeploymentException("No attribute builder deployed for namespace: " + namespace);
        }
        GAttributeInfo attribute = this.gbean.getGBeanInfo().getAttribute(name);
        if (attribute == null) {
            throw new DeploymentException("Unknown attribute " + name + " on " + this.gbean.getName());
        }
        String type = attribute.getType();
        Object value = builder.getValue(xmlObject, type, this.classLoader);
        this.gbean.setAttribute(name, value);
    }

    public void setXmlReference(String name, XmlObject xmlObject) throws DeploymentException {
        String namespace = xmlObject.getDomNode().getNamespaceURI();
        XmlReferenceBuilder builder = (XmlReferenceBuilder)this.xmlReferenceBuilderMap.get(namespace);
        if (builder == null) {
            throw new DeploymentException("No reference builder deployed for namespace: " + namespace);
        }
        Set references = builder.getReferences(xmlObject, this.context, this.j2eeContext, this.classLoader);
        if (references != null && !references.isEmpty()) {
            this.gbean.setReferencePatterns(name, references);
        }
    }

    public void setReference(String name, ReferenceType pattern, J2eeContext j2eeContext) throws DeploymentException {
        this.setReference(name, new PatternType[]{pattern}, j2eeContext);
    }

    public void setReference(String name, PatternType[] patterns, J2eeContext j2eeContext) throws DeploymentException {
        HashSet<ObjectName> patternNames = new HashSet<ObjectName>(patterns.length);
        for (int i = 0; i < patterns.length; ++i) {
            try {
                patternNames.add(this.buildObjectName(name, patterns[i], j2eeContext));
                continue;
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException("Invalid pattern for reference " + name + ": " + patterns[i], (Throwable)e);
            }
        }
        this.gbean.setReferencePatterns(name, patternNames);
    }

    private ObjectName buildObjectName(String refName, PatternType pattern, J2eeContext j2eeContext) throws MalformedObjectNameException, DeploymentException {
        if (pattern.isSetGbeanName()) {
            String gbeanName = pattern.getGbeanName();
            return ObjectName.getInstance(gbeanName);
        }
        String domain = pattern.isSetDomain() ? pattern.getDomain().trim() : null;
        String server = pattern.isSetServer() ? pattern.getServer().trim() : null;
        String application = pattern.isSetApplication() ? pattern.getApplication().trim() : null;
        String moduleType = pattern.isSetModuleType() ? pattern.getModuleType().trim() : null;
        String module = pattern.isSetModule() ? pattern.getModule().trim() : null;
        String type = pattern.isSetType() ? pattern.getType().trim() : null;
        String name = pattern.getName().trim();
        if (type == null) {
            boolean found = false;
            Set referenceInfos = this.gbean.getGBeanInfo().getReferences();
            Iterator iterator = referenceInfos.iterator();
            while (iterator.hasNext()) {
                GReferenceInfo referenceInfo = (GReferenceInfo)iterator.next();
                String testRefName = referenceInfo.getName();
                if (!testRefName.equals(refName)) continue;
                type = referenceInfo.getNameTypeName();
                found = true;
            }
            if (!found) {
                throw new DeploymentException("No reference named " + refName + " in gbean " + this.gbean.getName());
            }
        }
        return NameFactory.getComponentNameQuery((String)domain, (String)server, (String)application, (String)moduleType, (String)module, (String)name, (String)type, (J2eeContext)j2eeContext);
    }

    public GBeanData getGBeanData() {
        return this.gbean;
    }
}

