/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;

public class ProtocolGBean
implements GBeanLifecycle {
    private final Log log = LogFactory.getLog((Class)ProtocolGBean.class);
    private final String objectName;
    private Properties properties;
    private final String protocol;
    private String host;
    private String user;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ProtocolGBean() {
        this.objectName = null;
        this.protocol = null;
        this.properties = null;
    }

    public ProtocolGBean(String objectName, String protocol, Properties properties, String host, String user) {
        if (!$assertionsDisabled && protocol == null) {
            throw new AssertionError();
        }
        this.objectName = objectName;
        this.protocol = protocol;
        this.properties = properties == null ? new Properties() : properties;
        this.host = host;
        this.user = user;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void addOverrides(Properties props) {
        if (this.host != null) {
            props.put("mail." + this.protocol + ".host", this.host);
        }
        if (this.user != null) {
            props.put("mail." + this.protocol + ".user", this.user);
        }
    }

    public void doStart() throws Exception {
        this.log.debug((Object)("Started " + this.objectName));
    }

    public void doStop() throws Exception {
        this.log.debug((Object)("Stopped " + this.objectName));
    }

    public void doFail() {
        this.log.warn((Object)("Failed " + this.objectName));
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !ProtocolGBean.class.desiredAssertionStatus();
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)ProtocolGBean.class);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addAttribute("protocol", String.class, true);
        infoFactory.addAttribute("properties", Properties.class, true);
        infoFactory.addAttribute("host", String.class, true);
        infoFactory.addAttribute("user", String.class, true);
        infoFactory.addOperation("addOverrides", new Class[]{Properties.class});
        infoFactory.setConstructor(new String[]{"objectName", "protocol", "properties", "host", "user"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

