/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jmxremoting;

import java.util.HashMap;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.WaitingException;
import org.apache.geronimo.jmxremoting.Authenticator;
import org.apache.geronimo.kernel.Kernel;

public class JMXConnector
implements GBeanLifecycle {
    private final Kernel kernel;
    private final Log log;
    private final ClassLoader classLoader;
    private String url;
    private String applicationConfigName;
    private JMXConnectorServer server;
    public static final GBeanInfo GBEAN_INFO;

    public JMXConnector(Kernel kernel, String objectName, ClassLoader classLoader) {
        this.kernel = kernel;
        this.classLoader = classLoader;
        this.log = LogFactory.getLog((String)objectName);
    }

    public String getApplicationConfigName() {
        return this.applicationConfigName;
    }

    public void setApplicationConfigName(String applicationConfigName) {
        this.applicationConfigName = applicationConfigName;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void doStart() throws WaitingException, Exception {
        JMXServiceURL serviceURL = new JMXServiceURL(this.url);
        HashMap<String, Authenticator> env = new HashMap<String, Authenticator>();
        if (this.applicationConfigName != null) {
            env.put("jmx.remote.authenticator", new Authenticator(this.applicationConfigName, this.classLoader));
        } else {
            this.log.warn((Object)("Starting unauthenticating JMXConnector for " + serviceURL));
        }
        this.server = JMXConnectorServerFactory.newJMXConnectorServer(serviceURL, env, this.kernel.getMBeanServer());
        this.server.start();
        this.log.info((Object)("Started JMXConnector " + this.server.getAddress()));
    }

    public void doStop() throws Exception {
        this.server.stop();
        this.server = null;
        this.log.info((Object)("Stopped JMXConnector " + this.url));
    }

    public void doFail() {
        try {
            this.doStop();
            this.log.warn((Object)("Failure in JMXConnector " + this.url));
        }
        catch (Exception e) {
            this.log.warn((Object)"Error stopping JMXConnector after failure", (Throwable)e);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(JMXConnector.class);
        infoFactory.addAttribute("URL", String.class, true);
        infoFactory.addAttribute("applicationConfigName", String.class, true);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.setConstructor(new String[]{"kernel", "objectName", "classLoader"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

