/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jmxremoting;

import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.geronimo.jmxremoting.Credentials;

public class Authenticator
implements JMXAuthenticator {
    private final String configName;
    private final ClassLoader cl;

    public Authenticator(String configName, ClassLoader cl) {
        this.configName = configName;
        this.cl = cl;
    }

    public Subject authenticate(Object o) throws SecurityException {
        if (!(o instanceof String[])) {
            throw new IllegalArgumentException("Expected String[2], got " + o == null ? null : o.getClass().getName());
        }
        String[] params = (String[])o;
        if (params.length != 2) {
            throw new IllegalArgumentException("Expected String[2] but length was " + params.length);
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldCL = thread.getContextClassLoader();
        Credentials credentials = new Credentials(params[0], params[1]);
        try {
            thread.setContextClassLoader(this.cl);
            LoginContext context = new LoginContext(this.configName, credentials);
            context.login();
            Subject subject = context.getSubject();
            return subject;
        }
        catch (LoginException e) {
            throw new SecurityException("Invalid login");
        }
        finally {
            credentials.clear();
            thread.setContextClassLoader(oldCL);
        }
    }
}

