/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.management.impl;

import [Ljava.lang.String;;
import java.util.Hashtable;
import javax.management.ObjectName;
import javax.naming.Context;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.management.J2EEApplication;
import org.apache.geronimo.j2ee.management.J2EEServer;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.kernel.jmx.JMXUtil;

public class J2EEAppClientModuleImpl {
    private final String deploymentDescriptor;
    private final J2EEServer server;
    private final J2EEApplication application;
    private final Context componentContext;
    private final ClassLoader classLoader;
    public static final GBeanInfo GBEAN_INFO;

    public J2EEAppClientModuleImpl(Context componentContext, String objectName, J2EEServer server, J2EEApplication application, String deploymentDescriptor, ClassLoader classLoader) {
        this.componentContext = componentContext;
        ObjectName myObjectName = JMXUtil.getObjectName((String)objectName);
        this.verifyObjectName(myObjectName);
        this.server = server;
        this.application = application;
        this.deploymentDescriptor = deploymentDescriptor;
        this.classLoader = classLoader;
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"AppClientModule".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("AppClientModule object name j2eeType property must be 'AppClientModule'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("AppClientModule object must contain a name property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEServer")) {
            throw new InvalidObjectNameException("AppClientModule object name must contain a J2EEServer property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEApplication")) {
            throw new InvalidObjectNameException("AppClientModule object name must contain a J2EEApplication property", objectName);
        }
        if (keyPropertyList.size() != 4) {
            throw new InvalidObjectNameException("AppClientModule object name can only have j2eeType, name, J2EEApplication, and J2EEServer properties", objectName);
        }
    }

    public String getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public String getServer() {
        return this.server.getObjectName();
    }

    public String getApplication() {
        if (this.application == null) {
            return null;
        }
        return this.application.getObjectName();
    }

    public String[] getJavaVMs() {
        return this.server.getJavaVMs();
    }

    public Context getComponentContext() {
        return this.componentContext;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(J2EEAppClientModuleImpl.class);
        infoFactory.addReference("J2EEServer", J2EEServer.class);
        infoFactory.addReference("J2EEApplication", J2EEApplication.class);
        infoFactory.addAttribute("componentContext", Context.class, true);
        infoFactory.addAttribute("deploymentDescriptor", String.class, true);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addAttribute("server", String.class, false);
        infoFactory.addAttribute("application", String.class, false);
        infoFactory.addAttribute("javaVMs", String;.class, false);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.setConstructor(new String[]{"componentContext", "objectName", "J2EEServer", "J2EEApplication", "deploymentDescriptor", "classLoader"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

