/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.j2eeobjectnames;

import javax.management.ObjectName;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContext;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;

public class J2eeContextImpl
implements J2eeContext {
    private final String domainName;
    private final String serverName;
    private final String applicationName;
    private final String moduleName;
    private final String j2eeName;
    private final String j2eeType;

    public J2eeContextImpl(String domainName, String serverName, String applicationName, String moduleName, String j2eeName, String j2eeType) {
        this.domainName = domainName;
        this.serverName = serverName;
        this.applicationName = applicationName;
        this.moduleName = moduleName;
        this.j2eeName = j2eeName;
        this.j2eeType = j2eeType;
    }

    public J2eeContextImpl(ObjectName source, String moduleType) {
        this.domainName = source.getDomain();
        this.serverName = source.getKeyProperty(NameFactory.J2EE_SERVER);
        this.applicationName = source.getKeyProperty(NameFactory.J2EE_APPLICATION);
        this.moduleName = source.getKeyProperty(moduleType);
        this.j2eeType = source.getKeyProperty(NameFactory.J2EE_TYPE);
        this.j2eeName = source.getKeyProperty(NameFactory.J2EE_NAME);
    }

    public String getJ2eeDomainName() {
        return this.domainName;
    }

    public String getJ2eeServerName() {
        return this.serverName;
    }

    public String getJ2eeApplicationName() {
        return this.applicationName;
    }

    public String getJ2eeModuleName() {
        return this.moduleName;
    }

    public String getJ2eeName() {
        return this.j2eeName;
    }

    public String getJ2eeType() {
        return this.j2eeType;
    }

    public String getJ2eeDomainName(String override) {
        return override == null ? this.domainName : override;
    }

    public String getJ2eeServerName(String override) {
        return override == null ? this.serverName : override;
    }

    public String getJ2eeApplicationName(String override) {
        return override == null ? this.applicationName : override;
    }

    public String getJ2eeModuleName(String override) {
        return override == null ? this.moduleName : override;
    }

    public String getJ2eeName(String override) {
        return override == null ? this.j2eeName : override;
    }

    public String getJ2eeType(String override) {
        return override == null ? this.j2eeType : override;
    }
}

