/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.common.xml.XmlBeansUtil;
import org.apache.geronimo.deployment.ConfigurationBuilder;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.DeploymentException;
import org.apache.geronimo.deployment.service.GBeanAdapter;
import org.apache.geronimo.deployment.service.GBeanHelper;
import org.apache.geronimo.deployment.util.FileUtil;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.j2ee.deployment.ConnectorModule;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.EJBModule;
import org.apache.geronimo.j2ee.deployment.EJBReferenceBuilder;
import org.apache.geronimo.j2ee.deployment.GerGBeanAdapter;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.j2ee.management.impl.J2EEApplicationImpl;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerApplicationDocument;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerApplicationType;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerDependencyType;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerGbeanType;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerModuleType;
import org.apache.geronimo.xbeans.j2ee.ApplicationDocument;
import org.apache.geronimo.xbeans.j2ee.ApplicationType;
import org.apache.geronimo.xbeans.j2ee.ModuleType;
import org.apache.geronimo.xbeans.j2ee.WebType;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class EARConfigBuilder
implements ConfigurationBuilder {
    static final SchemaTypeLoader SCHEMA_TYPE_LOADER = XmlBeans.typeLoaderUnion((SchemaTypeLoader[])new SchemaTypeLoader[]{XmlBeans.typeLoaderForClassLoader((ClassLoader)org.apache.geronimo.xbeans.j2ee.String.class.getClassLoader()), XmlBeans.typeLoaderForClassLoader((ClassLoader)GerApplicationDocument.class.getClassLoader())});
    private static final String PARENT_ID = "org/apache/geronimo/Server";
    private final Kernel kernel;
    private final Repository repository;
    private final ModuleBuilder ejbConfigBuilder;
    private final ModuleBuilder webConfigBuilder;
    private final ModuleBuilder connectorConfigBuilder;
    private final EJBReferenceBuilder ejbReferenceBuilder;
    private final String j2eeServerName;
    private final String j2eeDomainName;
    private final ObjectName j2eeServer;
    private final ObjectName transactionContextManagerObjectName;
    private final ObjectName connectionTrackerObjectName;
    private final ObjectName transactionalTimerObjectName;
    private final ObjectName nonTransactionalTimerObjectName;
    public static final GBeanInfo GBEAN_INFO;

    public EARConfigBuilder(ObjectName j2eeServer, ObjectName transactionContextManagerObjectName, ObjectName connectionTrackerObjectName, ObjectName transactionalTimerObjectName, ObjectName nonTransactionalTimerObjectName, Repository repository, ModuleBuilder ejbConfigBuilder, EJBReferenceBuilder ejbReferenceBuilder, ModuleBuilder webConfigBuilder, ModuleBuilder connectorConfigBuilder, Kernel kernel) {
        this.kernel = kernel;
        this.repository = repository;
        this.j2eeServer = j2eeServer;
        this.j2eeServerName = j2eeServer.getKeyProperty("name");
        this.j2eeDomainName = j2eeServer.getDomain();
        this.ejbConfigBuilder = ejbConfigBuilder;
        this.ejbReferenceBuilder = ejbReferenceBuilder;
        this.webConfigBuilder = webConfigBuilder;
        this.connectorConfigBuilder = connectorConfigBuilder;
        this.transactionContextManagerObjectName = transactionContextManagerObjectName;
        this.connectionTrackerObjectName = connectionTrackerObjectName;
        this.transactionalTimerObjectName = transactionalTimerObjectName;
        this.nonTransactionalTimerObjectName = nonTransactionalTimerObjectName;
    }

    public boolean canConfigure(XmlObject plan) {
        if (plan instanceof GerApplicationDocument) {
            return true;
        }
        if (this.connectorConfigBuilder != null && this.connectorConfigBuilder.canHandlePlan(plan)) {
            return true;
        }
        if (this.ejbConfigBuilder != null && this.ejbConfigBuilder.canHandlePlan(plan)) {
            return true;
        }
        return this.webConfigBuilder != null && this.webConfigBuilder.canHandlePlan(plan);
    }

    public SchemaTypeLoader[] getTypeLoaders() {
        ArrayList<SchemaTypeLoader> typeLoaders = new ArrayList<SchemaTypeLoader>();
        typeLoaders.add(SCHEMA_TYPE_LOADER);
        if (this.connectorConfigBuilder != null) {
            typeLoaders.add(this.connectorConfigBuilder.getSchemaTypeLoader());
        }
        if (this.ejbConfigBuilder != null) {
            typeLoaders.add(this.ejbConfigBuilder.getSchemaTypeLoader());
        }
        if (this.webConfigBuilder != null) {
            typeLoaders.add(this.webConfigBuilder.getSchemaTypeLoader());
        }
        return typeLoaders.toArray(new SchemaTypeLoader[typeLoaders.size()]);
    }

    public XmlObject getDeploymentPlan(URL module) throws XmlException {
        XmlObject plan;
        try {
            URL moduleBase = module.toString().endsWith("/") ? module : new URL("jar:" + module.toString() + "!/");
            GerApplicationDocument gerAppDoc = (GerApplicationDocument)XmlBeansUtil.getXmlObject((URL)new URL(moduleBase, "META-INF/geronimo-application.xml"), (SchemaType)GerApplicationDocument.type);
            if (gerAppDoc != null) {
                return gerAppDoc;
            }
            GerApplicationDocument defaultPlan = this.createDefaultPlan(moduleBase);
            if (defaultPlan != null) {
                return defaultPlan;
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (this.webConfigBuilder != null && (plan = this.webConfigBuilder.getDeploymentPlan(module)) != null) {
            return plan;
        }
        if (this.ejbConfigBuilder != null && (plan = this.ejbConfigBuilder.getDeploymentPlan(module)) != null) {
            return plan;
        }
        if (this.connectorConfigBuilder != null && (plan = this.connectorConfigBuilder.getDeploymentPlan(module)) != null) {
            return plan;
        }
        return null;
    }

    private GerApplicationDocument createDefaultPlan(URL moduleBase) throws XmlException {
        ApplicationDocument applicationDoc;
        URL applicationXmlUrl = null;
        try {
            applicationXmlUrl = new URL(moduleBase, "META-INF/application.xml");
        }
        catch (MalformedURLException e) {
            return null;
        }
        try {
            InputStream ddInputStream = applicationXmlUrl.openStream();
            applicationDoc = this.getApplicationDocument(ddInputStream);
        }
        catch (IOException e) {
            return null;
        }
        catch (DeploymentException e) {
            return null;
        }
        if (applicationDoc == null) {
            return null;
        }
        GerApplicationDocument gerApplicationDocument = GerApplicationDocument.Factory.newInstance();
        GerApplicationType gerApplication = gerApplicationDocument.addNewApplication();
        gerApplication.setParentId(PARENT_ID);
        String id = applicationDoc.getApplication().getId();
        if (id == null) {
            id = moduleBase.getFile();
            if (id.endsWith("!/")) {
                id = id.substring(0, id.length() - 2);
            }
            if (id.endsWith(".ear")) {
                id = id.substring(0, id.length() - 4);
            }
            if (id.endsWith("/")) {
                id = id.substring(0, id.length() - 1);
            }
            id = id.substring(id.lastIndexOf(47) + 1);
        }
        gerApplication.setConfigId(id);
        return gerApplicationDocument;
    }

    public void buildConfiguration(File outfile, Manifest manifest, InputStream is, XmlObject plan) throws IOException, DeploymentException {
        File tmp = FileUtil.toTempFile((InputStream)is);
        this.buildConfiguration(outfile, manifest, new JarFile(tmp), plan);
    }

    public void buildConfiguration(File outfile, Manifest manifest, final File earFolder, final XmlObject plan) throws IOException, DeploymentException {
        if (!earFolder.isDirectory()) {
            this.buildConfiguration(outfile, manifest, new JarFile(earFolder), plan);
            return;
        }
        BuildConfigurationCallback callback = new BuildConfigurationCallback(){

            public ApplicationType addModules(URI configID, Set moduleLocations, Set modules) throws IOException, DeploymentException {
                ApplicationTypeLocator locator = new ApplicationTypeLocator(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public InputStream getApplication() throws DeploymentException, IOException {
                        File appXMLFile = new File(1.access$000(this.this$1), "META-INF/application.xml");
                        if (!appXMLFile.isFile()) {
                            throw new DeploymentException("Did not find META-INF/application.xml in earFile");
                        }
                        return new FileInputStream(appXMLFile);
                    }

                    public URL toURL(String uri) throws DeploymentException {
                        try {
                            return new File(1.access$000(this.this$1), uri).toURL();
                        }
                        catch (MalformedURLException e) {
                            throw new DeploymentException("Can not create URL", (Throwable)e);
                        }
                    }
                };
                return EARConfigBuilder.this.addModules(configID, plan, locator, moduleLocations, modules);
            }

            public void copyOverContent(EARContext earContext, Set moduleLocations) throws IOException {
                URI baseURI = earFolder.toURI();
                ArrayList files = new ArrayList();
                FileUtil.listRecursiveFiles((File)earFolder, files);
                Iterator iter = files.iterator();
                while (iter.hasNext()) {
                    File file = (File)iter.next();
                    URI path = baseURI.relativize(file.toURI());
                    boolean isNestedModuleFile = false;
                    Iterator iter2 = moduleLocations.iterator();
                    while (iter2.hasNext()) {
                        String moduleLocation = (String)iter2.next();
                        if (!path.toString().startsWith(moduleLocation)) continue;
                        isNestedModuleFile = true;
                        break;
                    }
                    if (isNestedModuleFile) continue;
                    earContext.addFile(path, file);
                }
            }

            public void installModule(ModuleBuilder moduleBuilder, EARContext earContext, Module module) throws IOException, DeploymentException {
                moduleBuilder.installModule(earFolder, earContext, module);
            }

            public void release() {
            }

            static /* synthetic */ File access$000(1 x0) {
                return x0.earFolder;
            }
        };
        this.buildConfiguration(outfile, manifest, callback, plan);
    }

    public void buildConfiguration(File outfile, Manifest manifest, final JarFile earFile, final XmlObject plan) throws IOException, DeploymentException {
        BuildConfigurationCallback callback = new BuildConfigurationCallback(){

            public ApplicationType addModules(URI configID, Set moduleLocations, Set modules) throws IOException, DeploymentException {
                ApplicationTypeLocator locator = new ApplicationTypeLocator(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public InputStream getApplication() throws DeploymentException, IOException {
                        JarEntry appXMLEntry = 3.access$200(this.this$1).getJarEntry("META-INF/application.xml");
                        if (appXMLEntry == null) {
                            throw new DeploymentException("Did not find META-INF/application.xml in earFile");
                        }
                        return 3.access$200(this.this$1).getInputStream(appXMLEntry);
                    }

                    public URL toURL(String uri) throws DeploymentException {
                        try {
                            String urlString = "jar:" + new File(3.access$200(this.this$1).getName()).toURL() + "!/" + uri;
                            return new URL(urlString);
                        }
                        catch (MalformedURLException e) {
                            throw new DeploymentException("Can not create URL", (Throwable)e);
                        }
                    }
                };
                return EARConfigBuilder.this.addModules(configID, plan, locator, moduleLocations, modules);
            }

            public void copyOverContent(EARContext earContext, Set moduleLocations) throws IOException {
                Enumeration<JarEntry> e = earFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    if (moduleLocations.contains(entry.getName())) continue;
                    earContext.addFile(URI.create(entry.getName()), earFile.getInputStream(entry));
                }
            }

            public void installModule(ModuleBuilder moduleBuilder, EARContext earContext, Module module) throws DeploymentException {
                moduleBuilder.installModule(earFile, earContext, module);
            }

            public void release() {
                if (null != earFile) {
                    try {
                        earFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            static /* synthetic */ JarFile access$200(3 x0) {
                return x0.earFile;
            }
        };
        this.buildConfiguration(outfile, manifest, callback, plan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildConfiguration(File outfile, Manifest manifest, BuildConfigurationCallback callback, XmlObject plan) throws IOException, DeploymentException {
        FileOutputStream fos = new FileOutputStream(outfile);
        try {
            Module module;
            URI configId = this.getConfigId(plan);
            ConfigurationModuleType type = this.getType(plan);
            URI parentId = this.getParentId(plan);
            HashSet moduleLocations = new HashSet();
            LinkedHashSet modules = new LinkedHashSet();
            ApplicationType application = callback.addModules(configId, moduleLocations, modules);
            String applicationName = application != null ? configId.toString() : "null";
            JarOutputStream os = new JarOutputStream(new BufferedOutputStream(fos));
            EARContext earContext = null;
            try {
                earContext = new EARContext(os, configId, type, parentId, this.kernel, this.j2eeDomainName, this.j2eeServerName, applicationName, this.transactionContextManagerObjectName, this.connectionTrackerObjectName, this.transactionalTimerObjectName, this.nonTransactionalTimerObjectName, this.ejbReferenceBuilder);
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException((Throwable)e);
            }
            if (application != null) {
                callback.copyOverContent(earContext, moduleLocations);
            }
            if (plan instanceof GerApplicationDocument) {
                GerApplicationDocument applicationDoc = (GerApplicationDocument)plan;
                GerApplicationType geronimoApplication = applicationDoc.getApplication();
                GerDependencyType[] dependencies = geronimoApplication.getDependencyArray();
                for (int i = 0; i < dependencies.length; ++i) {
                    earContext.addDependency(this.getDependencyURI(dependencies[i]));
                }
            }
            Iterator iterator = modules.iterator();
            while (iterator.hasNext()) {
                Module module2 = (Module)iterator.next();
                callback.installModule(this.getBuilder(module2), earContext, module2);
            }
            ClassLoader cl = earContext.getClassLoader(this.repository);
            Iterator iterator2 = modules.iterator();
            while (iterator2.hasNext()) {
                module = (Module)iterator2.next();
                this.getBuilder(module).initContext(earContext, module, cl);
            }
            if (plan instanceof GerApplicationDocument) {
                GerApplicationDocument applicationDoc = (GerApplicationDocument)plan;
                GerApplicationType geronimoApplication = applicationDoc.getApplication();
                GerGbeanType[] gbeans = geronimoApplication.getGbeanArray();
                for (int i = 0; i < gbeans.length; ++i) {
                    GBeanHelper.addGbean((GBeanAdapter)new GerGBeanAdapter(gbeans[i]), (ClassLoader)cl, (DeploymentContext)earContext);
                }
            }
            if (application != null) {
                GBeanMBean gbean = new GBeanMBean(J2EEApplicationImpl.GBEAN_INFO, cl);
                try {
                    gbean.setAttribute("deploymentDescriptor", (Object)application.toString());
                }
                catch (Exception e) {
                    throw new DeploymentException("Error initializing J2EEApplication managed object");
                }
                gbean.setReferencePatterns("j2eeServer", Collections.singleton(this.j2eeServer));
                earContext.addGBean(earContext.getApplicationObjectName(), gbean);
            }
            iterator2 = modules.iterator();
            while (iterator2.hasNext()) {
                module = (Module)iterator2.next();
                this.getBuilder(module).addGBeans(earContext, module, cl);
            }
            earContext.close();
            os.flush();
        }
        finally {
            callback.release();
            fos.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private ApplicationType addModules(URI configId, XmlObject plan, ApplicationTypeLocator appLocator, Set moduleLocations, Set modules) throws DeploymentException, IOException {
        void var6_8;
        ApplicationType application;
        if (plan instanceof GerApplicationDocument) {
            try {
                InputStream ddInputStream = appLocator.getApplication();
                application = this.getApplicationDocument(ddInputStream).getApplication();
            }
            catch (XmlException e) {
                throw new DeploymentException("Unable to parse application.xml", (Throwable)e);
            }
            ModuleType[] moduleTypes = application.getModuleArray();
            HashSet<Module> ejbModules = new HashSet<Module>();
            HashSet<Module> connectorModules = new HashSet<Module>();
            HashSet<Module> webModules = new HashSet<Module>();
            HashMap<String, EJBModule> moduleMap = new HashMap<String, EJBModule>();
            for (int i = 0; i < moduleTypes.length; ++i) {
                URI uri;
                ModuleType module = moduleTypes[i];
                Module currentModule = null;
                if (module.isSetEjb()) {
                    uri = URI.create(module.getEjb().getStringValue());
                    currentModule = new EJBModule(uri.toString(), uri);
                    if (this.ejbConfigBuilder == null) {
                        throw new DeploymentException("Can not deploy ejb application; No ejb deployer defined: " + currentModule.getURI());
                    }
                    moduleLocations.add(uri.toString());
                    ejbModules.add(currentModule);
                } else if (module.isSetWeb()) {
                    WebType web = module.getWeb();
                    URI uri2 = URI.create(web.getWebUri().getStringValue());
                    String contextRoot = web.getContextRoot().getStringValue();
                    currentModule = new WebModule(uri2.toString(), uri2, contextRoot);
                    if (this.webConfigBuilder == null) {
                        throw new DeploymentException("Can not deploy web application; No war deployer defined: " + currentModule.getURI());
                    }
                    moduleLocations.add(uri2.toString());
                    webModules.add(currentModule);
                } else if (module.isSetConnector()) {
                    uri = URI.create(module.getConnector().getStringValue());
                    currentModule = new ConnectorModule(uri.toString(), uri);
                    if (this.connectorConfigBuilder == null) {
                        throw new DeploymentException("Can not deploy resource adapter; No rar deployer defined: " + currentModule.getURI());
                    }
                    moduleLocations.add(uri.toString());
                    connectorModules.add(currentModule);
                }
                if (null == currentModule) continue;
                moduleMap.put(currentModule.getName(), (EJBModule)currentModule);
                if (!module.isSetAltDd()) continue;
                URL altDDURL = appLocator.toURL(module.getAltDd().getStringValue());
                currentModule.setAltSpecDD(altDDURL);
            }
            GerApplicationDocument gerApplication = (GerApplicationDocument)plan;
            GerModuleType[] gerModuleTypes = gerApplication.getApplication().getModuleArray();
            for (int i = 0; i < gerModuleTypes.length; ++i) {
                GerModuleType gerModuleType = gerModuleTypes[i];
                Module currentModule = null;
                if (gerModuleType.isSetEjb()) {
                    currentModule = (Module)moduleMap.get(gerModuleType.getEjb().getStringValue());
                } else if (gerModuleType.isSetWeb()) {
                    currentModule = (Module)moduleMap.get(gerModuleType.getWeb().getStringValue());
                } else if (gerModuleType.isSetConnector()) {
                    currentModule = (Module)moduleMap.get(gerModuleType.getConnector().getStringValue());
                }
                if (!gerModuleType.isSetAltDd() || null == currentModule) continue;
                URL altDDURL = appLocator.toURL(gerModuleType.getAltDd().getStringValue());
                currentModule.setAltVendorDD(altDDURL);
            }
            modules.addAll(connectorModules);
            modules.addAll(ejbModules);
            modules.addAll(webModules);
        } else if (this.webConfigBuilder != null && this.webConfigBuilder.canHandlePlan(plan)) {
            modules.add(this.webConfigBuilder.createModule(configId.toString(), plan));
            application = null;
        } else if (this.ejbConfigBuilder != null && this.ejbConfigBuilder.canHandlePlan(plan)) {
            modules.add(this.ejbConfigBuilder.createModule(configId.toString(), plan));
            application = null;
        } else if (this.connectorConfigBuilder != null && this.connectorConfigBuilder.canHandlePlan(plan)) {
            modules.add(this.connectorConfigBuilder.createModule(configId.toString(), plan));
            application = null;
        } else {
            throw new DeploymentException("Could not build module list; Unknown plan type");
        }
        return var6_8;
    }

    private ModuleBuilder getBuilder(Module module) {
        if (module instanceof EJBModule) {
            return this.ejbConfigBuilder;
        }
        if (module instanceof WebModule) {
            return this.webConfigBuilder;
        }
        if (module instanceof ConnectorModule) {
            return this.connectorConfigBuilder;
        }
        throw new IllegalArgumentException("Unknown module type: " + module.getClass().getName());
    }

    private ApplicationDocument getApplicationDocument(InputStream ddInputStream) throws XmlException, DeploymentException {
        XmlObject dd;
        try {
            dd = SchemaConversionUtils.parse((InputStream)ddInputStream);
        }
        catch (IOException e) {
            throw new DeploymentException((Throwable)e);
        }
        ApplicationDocument applicationDocument = SchemaConversionUtils.convertToApplicationSchema((XmlObject)dd);
        return applicationDocument;
    }

    private URI getParentId(XmlObject plan) throws DeploymentException {
        if (plan instanceof GerApplicationDocument) {
            GerApplicationDocument applicationDoc = (GerApplicationDocument)plan;
            GerApplicationType application = applicationDoc.getApplication();
            if (application.isSetParentId()) {
                try {
                    return new URI(application.getParentId());
                }
                catch (URISyntaxException e) {
                    throw new DeploymentException("Invalid parentId " + application.getParentId(), (Throwable)e);
                }
            }
            return null;
        }
        if (this.webConfigBuilder != null && this.webConfigBuilder.canHandlePlan(plan)) {
            return this.webConfigBuilder.getParentId(plan);
        }
        if (this.ejbConfigBuilder != null && this.ejbConfigBuilder.canHandlePlan(plan)) {
            return this.ejbConfigBuilder.getParentId(plan);
        }
        if (this.connectorConfigBuilder != null && this.connectorConfigBuilder.canHandlePlan(plan)) {
            return this.connectorConfigBuilder.getParentId(plan);
        }
        return null;
    }

    private URI getConfigId(XmlObject plan) throws DeploymentException {
        if (plan instanceof GerApplicationDocument) {
            GerApplicationDocument applicationDoc = (GerApplicationDocument)plan;
            GerApplicationType application = applicationDoc.getApplication();
            try {
                return new URI(application.getConfigId());
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Invalid configId " + application.getConfigId(), (Throwable)e);
            }
        }
        if (this.webConfigBuilder != null && this.webConfigBuilder.canHandlePlan(plan)) {
            return this.webConfigBuilder.getConfigId(plan);
        }
        if (this.ejbConfigBuilder != null && this.ejbConfigBuilder.canHandlePlan(plan)) {
            return this.ejbConfigBuilder.getConfigId(plan);
        }
        if (this.connectorConfigBuilder != null && this.connectorConfigBuilder.canHandlePlan(plan)) {
            return this.connectorConfigBuilder.getConfigId(plan);
        }
        throw new DeploymentException("Could not determine config id");
    }

    private ConfigurationModuleType getType(XmlObject plan) throws DeploymentException {
        if (plan instanceof GerApplicationDocument) {
            return ConfigurationModuleType.EAR;
        }
        if (this.webConfigBuilder != null && this.webConfigBuilder.canHandlePlan(plan)) {
            return ConfigurationModuleType.WAR;
        }
        if (this.ejbConfigBuilder != null && this.ejbConfigBuilder.canHandlePlan(plan)) {
            return ConfigurationModuleType.EJB;
        }
        if (this.connectorConfigBuilder != null && this.connectorConfigBuilder.canHandlePlan(plan)) {
            return ConfigurationModuleType.RAR;
        }
        throw new DeploymentException("Could not determine type");
    }

    private URI getDependencyURI(GerDependencyType dep) throws DeploymentException {
        URI uri;
        if (dep.isSetUri()) {
            try {
                uri = new URI(dep.getUri());
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Invalid dependency URI " + dep.getUri(), (Throwable)e);
            }
        }
        String id = dep.getGroupId() + "/jars/" + dep.getArtifactId() + '-' + dep.getVersion() + ".jar";
        try {
            uri = new URI(id);
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Unable to construct URI for groupId=" + dep.getGroupId() + ", artifactId=" + dep.getArtifactId() + ", version=" + dep.getVersion(), (Throwable)e);
        }
        return uri;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(EARConfigBuilder.class);
        infoFactory.addAttribute("j2eeServer", ObjectName.class, true);
        infoFactory.addAttribute("transactionContextManagerObjectName", ObjectName.class, true);
        infoFactory.addAttribute("connectionTrackerObjectName", ObjectName.class, true);
        infoFactory.addAttribute("transactionalTimerObjectName", ObjectName.class, true);
        infoFactory.addAttribute("nonTransactionalTimerObjectName", ObjectName.class, true);
        infoFactory.addReference("Repository", Repository.class);
        infoFactory.addReference("EJBConfigBuilder", ModuleBuilder.class);
        infoFactory.addReference("EJBReferenceBuilder", EJBReferenceBuilder.class);
        infoFactory.addReference("WebConfigBuilder", ModuleBuilder.class);
        infoFactory.addReference("ConnectorConfigBuilder", ModuleBuilder.class);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addInterface(ConfigurationBuilder.class);
        infoFactory.setConstructor(new String[]{"j2eeServer", "transactionContextManagerObjectName", "connectionTrackerObjectName", "transactionalTimerObjectName", "nonTransactionalTimerObjectName", "Repository", "EJBConfigBuilder", "EJBReferenceBuilder", "WebConfigBuilder", "ConnectorConfigBuilder", "kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private static interface ApplicationTypeLocator {
        public InputStream getApplication() throws DeploymentException, IOException;

        public URL toURL(String var1) throws DeploymentException;
    }

    private static interface BuildConfigurationCallback {
        public ApplicationType addModules(URI var1, Set var2, Set var3) throws IOException, DeploymentException;

        public void copyOverContent(EARContext var1, Set var2) throws IOException, DeploymentException;

        public void installModule(ModuleBuilder var1, EARContext var2, Module var3) throws IOException, DeploymentException;

        public void release();
    }
}

