/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.management.impl;

import java.util.Collection;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.j2ee.management.J2EEDeployedObject;
import org.apache.geronimo.j2ee.management.J2EEResource;
import org.apache.geronimo.j2ee.management.JVM;
import org.apache.geronimo.j2ee.management.impl.Util;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class ServerImpl {
    private static final String SERVER_VENDOR = "The Apache Software Foundation";
    private final ServerInfo serverInfo;
    private final Collection deployedObjects;
    private final Collection resources;
    private final Collection jvms;
    public static final GBeanInfo GBEAN_INFO;

    public ServerImpl(ServerInfo serverInfo, Collection deployedObjects, Collection resources, Collection jvms) {
        this.serverInfo = serverInfo;
        this.deployedObjects = deployedObjects;
        this.resources = resources;
        this.jvms = jvms;
    }

    public String[] getdeployedObjects() {
        return Util.getObjectNames(this.deployedObjects);
    }

    public String[] getresources() {
        return Util.getObjectNames(this.resources);
    }

    public String[] getjavaVMs() {
        return Util.getObjectNames(this.jvms);
    }

    public String getserverVendor() {
        return SERVER_VENDOR;
    }

    public String getserverVersion() {
        return this.serverInfo.getVersion();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(ServerImpl.class);
        infoFactory.addAttribute("deployedObjects", false);
        infoFactory.addAttribute("resources", false);
        infoFactory.addAttribute("javaVMs", false);
        infoFactory.addAttribute("serverVendor", false);
        infoFactory.addAttribute("serverVersion", false);
        infoFactory.addReference("ServerInfo", ServerInfo.class);
        infoFactory.addReference("DeployedObjects", J2EEDeployedObject.class);
        infoFactory.addReference("Resources", J2EEResource.class);
        infoFactory.addReference("JVMs", JVM.class);
        infoFactory.setConstructor(new String[]{"ServerInfo", "DeployedObjects", "Resources", "JVMs"}, new Class[]{ServerInfo.class, Collection.class, Collection.class, Collection.class});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

