/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.directory;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.geronimo.directory.MutableServerStartupConfiguration;
import org.apache.geronimo.xbeans.geronimo.directory.DirAttributeDocument;
import org.apache.geronimo.xbeans.geronimo.directory.DirBootStrapSchemasDocument;
import org.apache.geronimo.xbeans.geronimo.directory.DirContextEntryDocument;
import org.apache.geronimo.xbeans.geronimo.directory.DirDirectoryConfigurationDocument;
import org.apache.geronimo.xbeans.geronimo.directory.DirIndexedAttributesDocument;
import org.apache.geronimo.xbeans.geronimo.directory.DirPartitionDocument;
import org.apache.geronimo.xbeans.geronimo.directory.DirPartitionsDocument;
import org.apache.ldap.server.configuration.MutableContextPartitionConfiguration;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class DirectoryConfigurator {
    public void configure(ClassLoader cl, MutableServerStartupConfiguration startup, File file) throws Exception {
        String[] schemaList;
        DirBootStrapSchemasDocument.BootStrapSchemas schemas;
        DirPartitionDocument.Partition[] partitionList;
        DirDirectoryConfigurationDocument doc = this.parse(file);
        DirDirectoryConfigurationDocument.DirectoryConfiguration dirConfig = doc.getDirectoryConfiguration();
        DirPartitionsDocument.Partitions partitions = dirConfig.getPartitions();
        if (partitions != null && (partitionList = partitions.getPartitionArray()) != null) {
            HashSet<MutableContextPartitionConfiguration> partition = new HashSet<MutableContextPartitionConfiguration>();
            for (int i = 0; i < partitionList.length; ++i) {
                partition.add(this.processPartition(partitionList[i]));
            }
            startup.setContextPartitionConfigurations(partition);
        }
        if ((schemas = dirConfig.getBootStrapSchemas()) != null && (schemaList = schemas.getSchemaArray()) != null) {
            HashSet bootStrapSchemas = new HashSet();
            for (int i = 0; i < schemaList.length; ++i) {
                Class<?> clazz = cl.loadClass(schemaList[i]);
                bootStrapSchemas.add(clazz.newInstance());
            }
            startup.setBootstrapSchemas(bootStrapSchemas);
        }
    }

    private MutableContextPartitionConfiguration processPartition(DirPartitionDocument.Partition partition) {
        DirAttributeDocument.Attribute[] attributeList;
        DirContextEntryDocument.ContextEntry contextEntry;
        String[] attributeList2;
        MutableContextPartitionConfiguration mcpc = new MutableContextPartitionConfiguration();
        mcpc.setName(partition.getName());
        mcpc.setSuffix(partition.getSuffix());
        DirIndexedAttributesDocument.IndexedAttributes indexedAttributes = partition.getIndexedAttributes();
        if (indexedAttributes != null && (attributeList2 = indexedAttributes.getIndexedAttributeArray()) != null) {
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < attributeList2.length; ++i) {
                set.add(attributeList2[i]);
            }
            mcpc.setIndexedAttributes(set);
        }
        if ((contextEntry = partition.getContextEntry()) != null && (attributeList = contextEntry.getAttributeArray()) != null) {
            BasicAttributes attrs = new BasicAttributes(true);
            for (int i = 0; i < attributeList.length; ++i) {
                BasicAttribute attr = new BasicAttribute(attributeList[i].getId());
                String[] values = attributeList[i].getValueArray();
                for (int j = 0; j < values.length; ++j) {
                    attr.add(values[j]);
                }
                attrs.put(attr);
            }
            mcpc.setContextEntry((Attributes)attrs);
        }
        return mcpc;
    }

    private DirDirectoryConfigurationDocument parse(File file) throws Exception {
        ArrayList errors = new ArrayList();
        XmlObject config = XmlObject.Factory.parse((File)file, (XmlOptions)this.createXmlOptions(errors));
        if (errors.size() != 0) {
            throw new XmlException(errors.toArray().toString());
        }
        if (DirDirectoryConfigurationDocument.type.equals(config.schemaType())) {
            this.validateDD(config);
            return (DirDirectoryConfigurationDocument)config;
        }
        XmlObject result = config.changeType(DirDirectoryConfigurationDocument.type);
        this.validateDD(result);
        return (DirDirectoryConfigurationDocument)result;
    }

    private XmlOptions createXmlOptions(Collection errors) {
        HashMap<String, String> NAMESPACE_UPDATES = new HashMap<String, String>();
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/directory", "http://geronimo.apache.org/xml/ns/directory-1.0");
        XmlOptions options = new XmlOptions();
        options.setLoadLineNumbers();
        options.setErrorListener(errors);
        options.setLoadSubstituteNamespaces(NAMESPACE_UPDATES);
        options.setUseDefaultNamespace();
        return options;
    }

    private void validateDD(XmlObject dd) throws XmlException {
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setDocumentType(DirDirectoryConfigurationDocument.type);
        xmlOptions.setLoadLineNumbers();
        xmlOptions.setUseDefaultNamespace();
        ArrayList errors = new ArrayList();
        xmlOptions.setErrorListener(errors);
        if (!dd.validate(xmlOptions)) {
            throw new XmlException("Invalid directory descriptor: " + errors + "\nDescriptor: " + dd.toString(), null, errors);
        }
    }
}

