/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.derby;

import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.geronimo.derby.DerbySystem;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class DerbySystemGBean
implements DerbySystem,
GBeanLifecycle {
    private static final Log log = LogFactory.getLog((String)"DerbySystem");
    private static final String SYSTEM_HOME = "derby.system.home";
    private static final String SHUTDOWN_ALL = "jdbc:derby:;shutdown=true";
    private final ServerInfo serverInfo;
    private final String systemHome;
    private String actualHome;
    public static final GBeanInfo GBEAN_INFO;

    public DerbySystemGBean(ServerInfo serverInfo, String derbySystemHome) {
        this.serverInfo = serverInfo;
        this.systemHome = derbySystemHome;
    }

    public String getDerbyHome() {
        return this.actualHome;
    }

    public void doStart() throws Exception {
        this.actualHome = System.getProperty(SYSTEM_HOME);
        if (this.actualHome == null) {
            this.actualHome = this.serverInfo.resolveServerPath(this.systemHome);
        }
        System.setProperty(SYSTEM_HOME, this.actualHome);
        System.setProperty("derby.storage.fileSyncTransactionLog", "true");
        new EmbeddedDriver();
        log.debug((Object)("Started in " + this.actualHome));
    }

    public void doStop() throws Exception {
        try {
            DriverManager.getConnection(SHUTDOWN_ALL, null, null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        System.gc();
        log.debug((Object)"Stopped");
    }

    public void doFail() {
        try {
            DriverManager.getConnection(SHUTDOWN_ALL, null, null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        System.gc();
        log.warn((Object)"Failed");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)DerbySystemGBean.class);
        infoFactory.addAttribute("derbySystemHome", String.class, true);
        infoFactory.addAttribute("derbyHome", String.class, false);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.setConstructor(new String[]{"ServerInfo", "derbySystemHome"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

