/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.derby;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.geronimo.derby.DerbyLog;
import org.apache.geronimo.derby.DerbySystem;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.management.geronimo.Log;

public class DerbyLogGBean
implements DerbyLog {
    private static final Pattern FULL_LINE_PATTERN = Pattern.compile("^.*", 8);
    private final DerbySystem derby;
    private File logFile = null;
    public static final GBeanInfo GBEAN_INFO;

    public DerbyLogGBean(DerbySystem derby) {
        this.derby = derby;
    }

    public Log.SearchResults searchLog(Integer startLine, Integer endLine, Integer max, String text) {
        Pattern textPattern;
        if (this.logFile == null) {
            this.logFile = new File(this.derby.getDerbyHome(), "derby.log");
            if (!this.logFile.canRead()) {
                throw new IllegalStateException("Cannot read Derby log file at '" + this.logFile.getAbsolutePath() + "'");
            }
        }
        try {
            textPattern = text == null || text.equals("") ? null : Pattern.compile(text);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Bad regular expression '" + text + "'");
        }
        return DerbyLogGBean.searchFile(this.logFile, textPattern, startLine, endLine, max == null ? 1000 : Math.min(1000, max));
    }

    private static Log.SearchResults searchFile(File file, Pattern textSearch, Integer start, Integer stop, int max) {
        LinkedList<Log.LogMessage> list = new LinkedList<Log.LogMessage>();
        boolean capped = false;
        int lineCount = 0;
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            FileChannel fc = raf.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            CharBuffer cb = Charset.forName("US-ASCII").decode(bb);
            Matcher lines = FULL_LINE_PATTERN.matcher(cb);
            Matcher text = textSearch == null ? null : textSearch.matcher("");
            max = Math.min(max, 1000);
            while (lines.find()) {
                if (start != null && start > ++lineCount || stop != null && stop < lineCount) continue;
                CharSequence line = cb.subSequence(lines.start(), lines.end());
                if (text != null) {
                    text.reset(line);
                    if (!text.find()) continue;
                }
                list.add(new Log.LogMessage(lineCount, ((Object)line).toString()));
                if (list.size() <= max) continue;
                list.remove(0);
                capped = true;
            }
            fc.close();
            raf.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return new Log.SearchResults(lineCount, list.toArray(new Log.LogMessage[list.size()]), capped);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Derby Log", (Class)DerbyLogGBean.class);
        infoFactory.addReference("DerbySystem", DerbySystem.class, "GBean");
        infoFactory.addInterface(DerbyLog.class);
        infoFactory.setConstructor(new String[]{"DerbySystem"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

